/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.exception.locale;

import com.mybatisflex.core.exception.locale.Localizable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum LocalizedFormats implements Localizable
{
    OBJECT_NULL("{0} can not be null."),
    OBJECT_NULL_OR_BLANK("{0} can not be null or blank."),
    MAP_NULL_OR_EMPTY("{0} can not be null or empty."),
    ARRAY_NULL_OR_EMPTY("{0} array can not be null or empty."),
    DATASOURCE_TYPE_BLANK("The dataSource type can not be null or blank."),
    DATASOURCE_TYPE_NOT_FIND("Can not find the dataSource type: {0}"),
    DATASOURCE_CAN_NOT_INSTANCE("Can not new instance dataSource object by class: {0}"),
    DATASOURCE_JDBC_URL("Can not get the dataSource jdbcUrl."),
    UPDATE_ONLY_SUPPORT_1_TABLE("\"UpdateByQuery\" only support 1 table."),
    UPDATE_OR_DELETE_NOT_ALLOW("Not allowed \"UPDATE\" or \"DELETE\" a table without where condition."),
    ENTITY_VERSION_NULL("The version value of entity \"{0}\" must not be null."),
    KEY_GENERATOR_BLANK("The name of key generator must not be null or blank.");

    private final String sourceFormat;

    private LocalizedFormats(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    @Override
    public String getSourceString() {
        return this.sourceFormat;
    }

    @Override
    public String getLocalizedString(Locale locale) {
        try {
            String path = LocalizedFormats.class.getName().replace(".", "/");
            ResourceBundle bundle = ResourceBundle.getBundle("assets/" + path, locale);
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                return bundle.getString(this.name());
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.sourceFormat;
    }
}

