/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource;

import java.util.function.Supplier;

public class DataSourceKey {
    private static ThreadLocal<String> annotationKeyThreadLocal = new ThreadLocal();
    private static ThreadLocal<String> manualKeyThreadLocal = new ThreadLocal();
    public static String manualKey;

    private DataSourceKey() {
    }

    public static void use(String dataSourceKey) {
        manualKeyThreadLocal.set(dataSourceKey.trim());
    }

    public static void useWithAnnotation(String dataSourceKey) {
        annotationKeyThreadLocal.set(dataSourceKey.trim());
    }

    public static <T> T use(String dataSourceKey, Supplier<T> supplier) {
        try {
            DataSourceKey.use(dataSourceKey);
            T t = supplier.get();
            return t;
        }
        finally {
            DataSourceKey.clear();
        }
    }

    public static void use(String dataSourceKey, Runnable runnable) {
        try {
            DataSourceKey.use(dataSourceKey);
            runnable.run();
        }
        finally {
            DataSourceKey.clear();
        }
    }

    public static void clear() {
        annotationKeyThreadLocal.remove();
        manualKeyThreadLocal.remove();
    }

    public static String getByAnnotation() {
        return annotationKeyThreadLocal.get();
    }

    public static String getByManual() {
        return manualKeyThreadLocal.get();
    }

    public static String get() {
        String key = manualKeyThreadLocal.get();
        return key != null ? key : annotationKeyThreadLocal.get();
    }

    public static void setAnnotationKeyThreadLocal(ThreadLocal<String> annotationKeyThreadLocal) {
        DataSourceKey.annotationKeyThreadLocal = annotationKeyThreadLocal;
    }

    public static void setManualKeyThreadLocal(ThreadLocal<String> manualKeyThreadLocal) {
        DataSourceKey.manualKeyThreadLocal = manualKeyThreadLocal;
    }
}

