/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.core.table.DynamicSchemaProcessor;
import com.mybatisflex.core.table.DynamicTableProcessor;
import com.mybatisflex.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class TableManager {
    private static DynamicTableProcessor dynamicTableProcessor;
    private static DynamicSchemaProcessor dynamicSchemaProcessor;
    private static final ThreadLocal<Map<String, String>> tableNameMappingTL;
    private static final ThreadLocal<Map<String, String>> schemaMappingTL;

    private TableManager() {
    }

    public static DynamicTableProcessor getDynamicTableProcessor() {
        return dynamicTableProcessor;
    }

    public static void setDynamicTableProcessor(DynamicTableProcessor dynamicTableProcessor) {
        TableManager.dynamicTableProcessor = dynamicTableProcessor;
    }

    public static DynamicSchemaProcessor getDynamicSchemaProcessor() {
        return dynamicSchemaProcessor;
    }

    public static void setDynamicSchemaProcessor(DynamicSchemaProcessor dynamicSchemaProcessor) {
        TableManager.dynamicSchemaProcessor = dynamicSchemaProcessor;
    }

    public static void setHintTableMapping(String tableName, String mappingTable) {
        tableNameMappingTL.get().put(tableName, mappingTable);
    }

    public static String getHintTableMapping(String tableName) {
        return tableNameMappingTL.get().get(tableName);
    }

    public static void setHintSchemaMapping(String schema, String mappingSchema) {
        schemaMappingTL.get().put(schema, mappingSchema);
    }

    public static String getHintSchemaMapping(String schema) {
        return schemaMappingTL.get().get(schema);
    }

    public static String getRealTable(String tableName) {
        if (dynamicTableProcessor == null) {
            return tableName;
        }
        Map<String, String> mapping = tableNameMappingTL.get();
        String dynamicTableName = mapping.get(tableName);
        if (StringUtil.isNotBlank(dynamicTableName)) {
            return dynamicTableName;
        }
        dynamicTableName = dynamicTableProcessor.process(tableName);
        mapping.put(tableName, dynamicTableName);
        return dynamicTableName;
    }

    public static String getRealSchema(String schema) {
        if (dynamicSchemaProcessor == null) {
            return schema;
        }
        Map<String, String> mapping = schemaMappingTL.get();
        String dynamiSchema = mapping.get(schema);
        if (StringUtil.isNotBlank(dynamiSchema)) {
            return dynamiSchema;
        }
        dynamiSchema = dynamicSchemaProcessor.process(schema);
        mapping.put(schema, dynamiSchema);
        return dynamiSchema;
    }

    static {
        tableNameMappingTL = ThreadLocal.withInitial(HashMap::new);
        schemaMappingTL = ThreadLocal.withInitial(HashMap::new);
    }
}

