/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.transaction.TransactionContext;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class FlexResultSetHandler
extends DefaultResultSetHandler {
    public FlexResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler<?> resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        super(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
    }

    public <E> Cursor<E> handleCursorResultSets(Statement stmt) throws SQLException {
        Cursor defaultCursor = super.handleCursorResultSets(stmt);
        if (TransactionContext.getXID() != null) {
            return new FlexCursor(defaultCursor);
        }
        return defaultCursor;
    }

    static class FlexCursor<T>
    implements Cursor<T> {
        private final Cursor<T> originalCursor;

        public FlexCursor(Cursor<T> cursor) {
            this.originalCursor = cursor;
            TransactionContext.holdCursor(cursor);
        }

        public void close() {
        }

        public boolean isOpen() {
            return this.originalCursor.isOpen();
        }

        public boolean isConsumed() {
            return this.originalCursor.isConsumed();
        }

        public int getCurrentIndex() {
            return this.originalCursor.getCurrentIndex();
        }

        public Iterator<T> iterator() {
            return this.originalCursor.iterator();
        }
    }
}

