/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.logicdelete.impl;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexAssert;
import com.mybatisflex.core.logicdelete.AbstractLogicDeleteProcessor;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import java.util.List;

public class PrimaryKeyLogicDeleteProcessor
extends AbstractLogicDeleteProcessor {
    @Override
    public String buildLogicNormalCondition(String logicColumn, TableInfo tableInfo, IDialect dialect) {
        return dialect.wrap(logicColumn) + " IS NULL";
    }

    @Override
    public String buildLogicDeletedSet(String logicColumn, TableInfo tableInfo, IDialect dialect) {
        List<IdInfo> primaryKeyList = tableInfo.getPrimaryKeyList();
        FlexAssert.notEmpty(primaryKeyList, "Entity must have one primary key.");
        String column = primaryKeyList.get(0).getColumn();
        return dialect.wrap(logicColumn) + " = " + dialect.wrap(column);
    }

    @Override
    public Object getLogicNormalValue() {
        return null;
    }

    @Override
    public Object getLogicDeletedValue() {
        return null;
    }
}

