/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource;

import com.mybatisflex.core.datasource.DataSourceDecipher;
import com.mybatisflex.core.datasource.DataSourceProperty;
import com.mybatisflex.core.util.ClassUtil;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.apache.ibatis.logging.LogFactory;

public class DataSourceManager {
    private static DataSourceDecipher decipher;

    public static DataSourceDecipher getDecipher() {
        return decipher;
    }

    public static void setDecipher(DataSourceDecipher decipher) {
        DataSourceManager.decipher = decipher;
    }

    public static void decryptDataSource(DataSource dataSource) {
        if (decipher == null) {
            return;
        }
        for (DataSourceProperty property : DataSourceProperty.values()) {
            String value;
            Method getterMethod = ClassUtil.getAnyMethod(dataSource.getClass(), property.getGetterMethods());
            if (getterMethod == null || (value = DataSourceManager.invokeMethod(getterMethod, dataSource, new Object[0])) == null) continue;
            value = decipher.decrypt(property, value);
            Method setter = ClassUtil.getAnyMethod(dataSource.getClass(), property.getSetterMethods());
            if (setter == null || value == null) continue;
            DataSourceManager.invokeMethod(setter, dataSource, value);
        }
    }

    static String invokeMethod(Method method, Object object, Object ... params) {
        try {
            return (String)method.invoke(object, params);
        }
        catch (Exception e) {
            LogFactory.getLog(DataSourceManager.class).error("Can not invoke method: " + method.getName(), (Throwable)e);
            return null;
        }
    }
}

