/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.activerecord;

import com.mybatisflex.core.activerecord.MapperModel;
import com.mybatisflex.core.activerecord.query.QueryModel;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.util.SqlUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;

public abstract class Model<T extends Model<T>>
extends QueryModel<T>
implements MapperModel<T>,
Serializable {
    public boolean remove() {
        return SqlUtil.toBool(this.baseMapper().deleteByQuery(this.queryWrapper()));
    }

    public boolean update() {
        return this.update(true);
    }

    public boolean update(boolean ignoreNulls) {
        return SqlUtil.toBool(this.baseMapper().updateByQuery(this, ignoreNulls, this.queryWrapper()));
    }

    public long count() {
        return this.baseMapper().selectCountByQuery(this.queryWrapper());
    }

    public boolean exists() {
        return SqlUtil.toBool(this.count());
    }

    public T one() {
        return (T)((Model)this.baseMapper().selectOneByQuery(this.queryWrapper()));
    }

    public T oneWithRelations() {
        return (T)((Model)this.baseMapper().selectOneWithRelationsByQuery(this.queryWrapper().limit(1)));
    }

    public Optional<T> oneOpt() {
        return Optional.ofNullable(this.one());
    }

    public Optional<T> oneWithRelationsOpt() {
        return Optional.ofNullable(this.oneWithRelations());
    }

    public List<T> list() {
        return this.baseMapper().selectListByQuery(this.queryWrapper());
    }

    public List<T> listWithRelations() {
        return this.baseMapper().selectListWithRelationsByQuery(this.queryWrapper());
    }

    public Page<T> page(Page<T> page) {
        return this.baseMapper().paginate(page, this.queryWrapper());
    }

    public Page<T> pageWithRelations(Page<T> page) {
        return this.baseMapper().paginateWithRelations(page, this.queryWrapper());
    }
}

