/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core;

import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.dialect.DbType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

public class FlexGlobalConfig {
    private boolean printBanner = true;
    private DbType dbType = DbType.MYSQL;
    private Configuration configuration;
    private SqlSessionFactory sqlSessionFactory;
    private KeyConfig keyConfig;
    private Map<Class<?>, SetListener> entitySetListeners = new ConcurrentHashMap();
    private Map<Class<?>, UpdateListener> entityUpdateListeners = new ConcurrentHashMap();
    private Map<Class<?>, InsertListener> entityInsertListeners = new ConcurrentHashMap();
    private Object normalValueOfLogicDelete = 0;
    private Object deletedValueOfLogicDelete = 1;
    private int defaultPageSize = 10;
    private int defaultRelationQueryDepth = 2;
    private static ConcurrentHashMap<String, FlexGlobalConfig> globalConfigs = new ConcurrentHashMap();
    private static FlexGlobalConfig defaultConfig = new FlexGlobalConfig();

    public boolean isPrintBanner() {
        return this.printBanner;
    }

    public void setPrintBanner(boolean printBanner) {
        this.printBanner = printBanner;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        DataSource dataSource = configuration.getEnvironment().getDataSource();
        if (dataSource instanceof FlexDataSource) {
            this.dbType = ((FlexDataSource)dataSource).getDefaultDbType();
        }
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public KeyConfig getKeyConfig() {
        return this.keyConfig;
    }

    public void setKeyConfig(KeyConfig keyConfig) {
        this.keyConfig = keyConfig;
    }

    public Map<Class<?>, SetListener> getEntitySetListeners() {
        return this.entitySetListeners;
    }

    public void setEntitySetListeners(Map<Class<?>, SetListener> entitySetListeners) {
        this.entitySetListeners = entitySetListeners;
    }

    public Map<Class<?>, UpdateListener> getEntityUpdateListeners() {
        return this.entityUpdateListeners;
    }

    public void setEntityUpdateListeners(Map<Class<?>, UpdateListener> entityUpdateListeners) {
        this.entityUpdateListeners = entityUpdateListeners;
    }

    public Map<Class<?>, InsertListener> getEntityInsertListeners() {
        return this.entityInsertListeners;
    }

    public void setEntityInsertListeners(Map<Class<?>, InsertListener> entityInsertListeners) {
        this.entityInsertListeners = entityInsertListeners;
    }

    public void registerSetListener(SetListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entitySetListeners.put(aClass, listener);
        }
    }

    public void registerUpdateListener(UpdateListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entityUpdateListeners.put(aClass, listener);
        }
    }

    public void registerInsertListener(InsertListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entityInsertListeners.put(aClass, listener);
        }
    }

    public SetListener getSetListener(Class<?> entityClass) {
        return this.entitySetListeners.get(entityClass);
    }

    public List<SetListener> getSupportedSetListener(Class<?> entityClass, boolean interfaceOnly) {
        HashMap map = new HashMap();
        if (!interfaceOnly) {
            this.doGetSupportedSetListener(entityClass, map);
        }
        while (entityClass.getSuperclass() != null) {
            Class<?>[] interfaces;
            for (Class<?> interfaceClass : interfaces = entityClass.getInterfaces()) {
                this.doGetSupportedSetListener(interfaceClass, map);
            }
            entityClass = entityClass.getSuperclass();
        }
        return new ArrayList<SetListener>(map.values());
    }

    private void doGetSupportedSetListener(Class<?> childClass, Map<Class<?>, SetListener> listeners) {
        SetListener setListener = null;
        while (setListener == null && childClass != null) {
            setListener = this.entitySetListeners.get(childClass);
            childClass = childClass.getSuperclass();
        }
        if (setListener != null) {
            listeners.put(childClass, setListener);
        }
    }

    public UpdateListener getUpdateListener(Class<?> entityClass) {
        return this.entityUpdateListeners.get(entityClass);
    }

    public List<UpdateListener> getSupportedUpdateListener(Class<?> entityClass, boolean interfaceOnly) {
        HashMap map = new HashMap();
        if (!interfaceOnly) {
            this.doGetSupportedUpdateListener(entityClass, map);
        }
        while (entityClass.getSuperclass() != null) {
            Class<?>[] interfaces;
            for (Class<?> interfaceClass : interfaces = entityClass.getInterfaces()) {
                this.doGetSupportedUpdateListener(interfaceClass, map);
            }
            entityClass = entityClass.getSuperclass();
        }
        return new ArrayList<UpdateListener>(map.values());
    }

    private void doGetSupportedUpdateListener(Class<?> childClass, Map<Class<?>, UpdateListener> listeners) {
        UpdateListener updateListener = null;
        while (updateListener == null && childClass != null) {
            updateListener = this.entityUpdateListeners.get(childClass);
            childClass = childClass.getSuperclass();
        }
        if (updateListener != null) {
            listeners.put(childClass, updateListener);
        }
    }

    public InsertListener getInsertListener(Class<?> entityClass) {
        return this.entityInsertListeners.get(entityClass);
    }

    public List<InsertListener> getSupportedInsertListener(Class<?> entityClass, boolean interfaceOnly) {
        HashMap map = new HashMap();
        if (!interfaceOnly) {
            this.doGetSupportedInsertListener(entityClass, map);
        }
        while (entityClass.getSuperclass() != null) {
            Class<?>[] interfaces;
            for (Class<?> interfaceClass : interfaces = entityClass.getInterfaces()) {
                this.doGetSupportedInsertListener(interfaceClass, map);
            }
            entityClass = entityClass.getSuperclass();
        }
        return new ArrayList<InsertListener>(map.values());
    }

    private void doGetSupportedInsertListener(Class<?> childClass, Map<Class<?>, InsertListener> listeners) {
        InsertListener insertListener = null;
        while (insertListener == null && childClass != null) {
            insertListener = this.entityInsertListeners.get(childClass);
            childClass = childClass.getSuperclass();
        }
        if (insertListener != null) {
            listeners.put(childClass, insertListener);
        }
    }

    public Object getNormalValueOfLogicDelete() {
        return this.normalValueOfLogicDelete;
    }

    public void setNormalValueOfLogicDelete(Object normalValueOfLogicDelete) {
        if (normalValueOfLogicDelete == null) {
            throw new NullPointerException("normalValueOfLogicDelete can not be null.");
        }
        this.normalValueOfLogicDelete = normalValueOfLogicDelete;
    }

    public Object getDeletedValueOfLogicDelete() {
        return this.deletedValueOfLogicDelete;
    }

    public void setDeletedValueOfLogicDelete(Object deletedValueOfLogicDelete) {
        if (deletedValueOfLogicDelete == null) {
            throw new NullPointerException("deletedValueOfLogicDelete can not be null.");
        }
        this.deletedValueOfLogicDelete = deletedValueOfLogicDelete;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    public int getDefaultRelationQueryDepth() {
        return this.defaultRelationQueryDepth;
    }

    public void setDefaultRelationQueryDepth(int defaultRelationQueryDepth) {
        this.defaultRelationQueryDepth = defaultRelationQueryDepth;
    }

    public FlexDataSource getDataSource() {
        return (FlexDataSource)this.getConfiguration().getEnvironment().getDataSource();
    }

    public static ConcurrentHashMap<String, FlexGlobalConfig> getGlobalConfigs() {
        return globalConfigs;
    }

    public static void setGlobalConfigs(ConcurrentHashMap<String, FlexGlobalConfig> globalConfigs) {
        FlexGlobalConfig.globalConfigs = globalConfigs;
    }

    public static FlexGlobalConfig getDefaultConfig() {
        return defaultConfig;
    }

    public static void setDefaultConfig(FlexGlobalConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null.");
        }
        defaultConfig = config;
    }

    public static FlexGlobalConfig getConfig(Configuration configuration) {
        return FlexGlobalConfig.getConfig(configuration.getEnvironment().getId());
    }

    public static FlexGlobalConfig getConfig(String environmentId) {
        return globalConfigs.get(environmentId);
    }

    public static synchronized void setConfig(String id, FlexGlobalConfig config, boolean isDefault) {
        if (isDefault) {
            defaultConfig.setSqlSessionFactory(config.sqlSessionFactory);
            defaultConfig.setConfiguration(config.configuration);
        }
        globalConfigs.put(id, isDefault ? defaultConfig : config);
    }

    public static class KeyConfig {
        private KeyType keyType;
        private String value;
        private boolean before = true;

        public KeyType getKeyType() {
            return this.keyType;
        }

        public void setKeyType(KeyType keyType) {
            this.keyType = keyType;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isBefore() {
            return this.before;
        }

        public void setBefore(boolean before) {
            this.before = before;
        }
    }
}

