/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class OperatorSelectCondition
extends QueryCondition {
    private final String operator;
    private QueryWrapper queryWrapper;

    public OperatorSelectCondition(String operator, QueryWrapper queryWrapper) {
        this.operator = operator;
        this.queryWrapper = queryWrapper;
    }

    public QueryWrapper getQueryWrapper() {
        return this.queryWrapper;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String childSql;
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective() && StringUtil.hasText(childSql = dialect.buildSelectSql(this.queryWrapper, queryTables))) {
            QueryCondition prevEffectiveCondition = this.getPrevEffectiveCondition();
            if (prevEffectiveCondition != null && this.connector != null) {
                sql.append((Object)this.connector);
            }
            sql.append(this.operator).append("(").append(childSql).append(")");
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    @Override
    public Object getValue() {
        return this.checkEffective() ? this.queryWrapper.getAllValueArray() : null;
    }

    @Override
    boolean containsTable(String ... tables) {
        QueryCondition condition = this.queryWrapper.getWhereQueryCondition();
        return condition != null && condition.containsTable(tables);
    }

    @Override
    public OperatorSelectCondition clone() {
        OperatorSelectCondition clone = (OperatorSelectCondition)super.clone();
        clone.queryWrapper = ObjectUtil.clone(this.queryWrapper);
        return clone;
    }
}

