/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DistinctQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private List<QueryColumn> queryColumns;

    public DistinctQueryColumn(QueryColumn ... queryColumns) {
        this.queryColumns = CollectionUtil.newArrayList(queryColumns);
    }

    public List<QueryColumn> getQueryColumns() {
        return this.queryColumns;
    }

    public void setQueryColumns(List<QueryColumn> queryColumns) {
        this.queryColumns = queryColumns;
    }

    @Override
    protected String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        if (CollectionUtil.isEmpty(queryTables)) {
            return "";
        }
        return "DISTINCT " + StringUtil.join(", ", this.queryColumns, queryColumn -> queryColumn.toSelectSql(queryTables, dialect));
    }

    @Override
    public String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        if (CollectionUtil.isEmpty(queryTables)) {
            return "";
        }
        String sql = "DISTINCT " + StringUtil.join(", ", this.queryColumns, queryColumn -> queryColumn.toSelectSql(queryTables, dialect));
        return sql + WrapperUtil.buildColumnAlias(this.alias, dialect);
    }

    @Override
    public DistinctQueryColumn clone() {
        DistinctQueryColumn clone = (DistinctQueryColumn)super.clone();
        clone.queryColumns = CollectionUtil.cloneArrayList(this.queryColumns);
        return clone;
    }

    @Override
    public Object[] getParamValues() {
        if (CollectionUtil.isEmpty(this.queryColumns)) {
            return FlexConsts.EMPTY_ARRAY;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        for (QueryColumn queryColumn : this.queryColumns) {
            if (!(queryColumn instanceof HasParamsColumn)) continue;
            Object[] paramValues = ((HasParamsColumn)((Object)queryColumn)).getParamValues();
            params.addAll(Arrays.asList(paramValues));
        }
        return params.toArray();
    }
}

