/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mask;

import com.mybatisflex.core.mask.MaskProcessor;

public class Masks {
    public static final String MOBILE = "mobile";
    public static final String FIXED_PHONE = "fixed_phone";
    public static final String ID_CARD_NUMBER = "id_card_number";
    public static final String CHINESE_NAME = "chinese_name";
    public static final String ADDRESS = "address";
    public static final String EMAIL = "email";
    public static final String PASSWORD = "password";
    public static final String CAR_LICENSE = "car_license";
    public static final String BANK_CARD_NUMBER = "bank_card_number";
    static MaskProcessor MOBILE_PROCESSOR = data -> {
        if (data instanceof String && ((String)data).startsWith("1") && ((String)data).length() == 11) {
            return Masks.mask((String)data, 3, 4, 4);
        }
        return data;
    };
    static MaskProcessor FIXED_PHONE_PROCESSOR = data -> {
        if (data instanceof String && ((String)data).length() > 5) {
            return Masks.mask((String)data, 3, 2, ((String)data).length() - 5);
        }
        return data;
    };
    static MaskProcessor ID_CARD_NUMBER_PROCESSOR = data -> {
        if (data instanceof String && ((String)data).length() >= 15) {
            return Masks.mask((String)data, 3, 4, ((String)data).length() - 7);
        }
        return data;
    };
    static MaskProcessor CHINESE_NAME_PROCESSOR = data -> {
        if (data instanceof String) {
            String name = (String)data;
            if (name.length() == 2) {
                return name.charAt(0) + "*";
            }
            if (name.length() == 3) {
                return name.charAt(0) + "*" + name.charAt(2);
            }
            if (name.length() == 4) {
                return "**" + name.substring(2, 4);
            }
            if (name.length() > 4) {
                return Masks.mask(name, 2, 1, name.length() - 3);
            }
        }
        return data;
    };
    static MaskProcessor ADDRESS_PROCESSOR = data -> {
        if (data instanceof String) {
            String address = (String)data;
            if (address.length() > 6) {
                return Masks.mask(address, 6, 0, 3);
            }
            if (address.length() > 3) {
                return Masks.mask(address, 3, 0, 3);
            }
        }
        return data;
    };
    static MaskProcessor EMAIL_PROCESSOR = data -> {
        if (data instanceof String && ((String)data).contains("@")) {
            String fullEmail = (String)data;
            int indexOf = fullEmail.lastIndexOf("@");
            String email = fullEmail.substring(0, indexOf);
            if (email.length() == 1) {
                return "*" + fullEmail.substring(indexOf);
            }
            if (email.length() == 2) {
                return "**" + fullEmail.substring(indexOf);
            }
            if (email.length() < 5) {
                return Masks.mask(email, 2, 0, email.length() - 2) + fullEmail.substring(indexOf);
            }
            return Masks.mask(email, 3, 0, email.length() - 3) + fullEmail.substring(indexOf);
        }
        return data;
    };
    static MaskProcessor PASSWORD_PROCESSOR = data -> {
        if (data instanceof String) {
            return Masks.mask((String)data, 0, 0, ((String)data).length());
        }
        return data;
    };
    static MaskProcessor CAR_LICENSE_PROCESSOR = data -> {
        if (data instanceof String) {
            return Masks.mask((String)data, 3, 1, ((String)data).length() - 4);
        }
        return data;
    };
    static MaskProcessor BANK_CARD_PROCESSOR = data -> {
        if (data instanceof String && ((String)data).length() >= 8) {
            return Masks.mask((String)data, 4, 4, 4);
        }
        return data;
    };

    private Masks() {
    }

    private static String createMask(int count) {
        StringBuilder mask = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            mask.append("*");
        }
        return mask.toString();
    }

    private static String mask(String needToMaskString, int keepFirstCount, int keepLastCount, int maskCount) {
        return needToMaskString.substring(0, keepFirstCount) + Masks.createMask(maskCount) + needToMaskString.substring(needToMaskString.length() - keepLastCount);
    }
}

