/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.field;

import com.mybatisflex.core.exception.FlexAssert;
import com.mybatisflex.core.field.FieldQuery;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import java.io.Serializable;

public class FieldQueryBuilder<T>
implements Serializable {
    private FieldQuery.Builder<?> builder;

    public FieldQuery.Builder<T> field(LambdaGetter<T> fn) {
        return this.createBuilder(fn);
    }

    public <N> FieldQuery.Builder<N> nestedField(LambdaGetter<N> fn) {
        return this.createBuilder(fn);
    }

    private <R> FieldQuery.Builder<R> createBuilder(LambdaGetter fn) {
        FlexAssert.notNull(fn, "Field can not be null.");
        Class<?> entityClass = LambdaUtil.getImplClass(fn);
        String fieldName = LambdaUtil.getFieldName(fn);
        this.builder = new FieldQuery.Builder(entityClass, fieldName);
        return this.builder;
    }

    public FieldQuery build() {
        return this.builder.build();
    }
}

