/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.audit.MessageCollector;
import com.mybatisflex.core.audit.MessageReporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractMessageCollector
implements MessageCollector {
    private final MessageReporter messageSender;
    private final List<AuditMessage> messages = Collections.synchronizedList(new ArrayList());
    private final ReentrantReadWriteLock rrwLock = new ReentrantReadWriteLock();

    protected AbstractMessageCollector(MessageReporter messageSender) {
        this.messageSender = messageSender;
    }

    @Override
    public void collect(AuditMessage message) {
        try {
            this.rrwLock.readLock().lock();
            this.messages.add(message);
        }
        finally {
            this.rrwLock.readLock().unlock();
        }
    }

    protected void doSendMessages() {
        ArrayList<AuditMessage> sendMessages;
        if (this.messages.isEmpty()) {
            return;
        }
        try {
            this.rrwLock.writeLock().lock();
            sendMessages = new ArrayList<AuditMessage>(this.messages);
            this.messages.clear();
        }
        finally {
            this.rrwLock.writeLock().unlock();
        }
        this.messageSender.sendMessages(sendMessages);
    }

    public void release() {
        this.doSendMessages();
    }

    protected List<AuditMessage> getMessages() {
        return this.messages;
    }

    protected MessageReporter getMessageSender() {
        return this.messageSender;
    }
}

