/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.List;
import org.jeecg.common.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PmsUtil {
    private static final Logger log = LoggerFactory.getLogger(PmsUtil.class);
    private static String uploadPath;

    @Value(value="${jeecg.path.upload}")
    public void setUploadPath(String uploadPath) {
        PmsUtil.uploadPath = uploadPath;
    }

    public static String saveErrorTxtByList(List<String> msg, String name) {
        Date d = new Date();
        String saveDir = "logs" + File.separator + DateUtils.yyyyMMdd.get().format(d) + File.separator;
        String saveFullDir = uploadPath + File.separator + saveDir;
        File saveFile = new File(saveFullDir);
        if (!saveFile.exists()) {
            saveFile.mkdirs();
        }
        name = name + DateUtils.yyyymmddhhmmss.get().format(d) + Math.round(Math.random() * 10000.0);
        String saveFilePath = saveFullDir + name + ".txt";
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(saveFilePath));){
            for (String s : msg) {
                if (s.indexOf("_") > 0) {
                    String[] arr = s.split("_");
                    bw.write("\u7b2c" + arr[0] + "\u884c:" + arr[1]);
                } else {
                    bw.write(s);
                }
                bw.write("\r\n");
            }
            bw.flush();
        }
        catch (Exception e) {
            log.info("excel\u5bfc\u5165\u751f\u6210\u9519\u8bef\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        return saveDir + name + ".txt";
    }
}

