/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.query;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryCondition;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.util.JeecgDataAutorUtils;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.SqlInjectionUtil;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.NumberUtils;

public class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    public static final String SQL_RULES_COLUMN = "SQL_RULES_COLUMN";
    private static final String BEGIN = "_begin";
    private static final String END = "_end";
    private static final String MULTI = "_MultiString";
    private static final String STAR = "*";
    private static final String COMMA = ",";
    private static final String NOT_EQUAL = "!";
    private static final String QUERY_SEPARATE_KEYWORD = " ";
    private static final String SUPER_QUERY_PARAMS = "superQueryParams";
    private static final String SUPER_QUERY_MATCH_TYPE = "superQueryMatchType";
    public static final String SQL_SQ = "'";
    private static final String ORDER_COLUMN = "column";
    private static final String ORDER_TYPE = "order";
    private static final String ORDER_TYPE_ASC = "ASC";
    private static final ThreadLocal<SimpleDateFormat> local = new ThreadLocal();

    private static SimpleDateFormat getTime() {
        SimpleDateFormat time = local.get();
        if (time == null) {
            time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            local.set(time);
        }
        return time;
    }

    public static <T> QueryWrapper<T> initQueryWrapper(T searchObj, Map<String, String[]> parameterMap) {
        long start = System.currentTimeMillis();
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryGenerator.installMplus(queryWrapper, searchObj, parameterMap);
        log.debug("---\u67e5\u8be2\u6761\u4ef6\u6784\u9020\u5668\u521d\u59cb\u5316\u5b8c\u6210,\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2----");
        return queryWrapper;
    }

    public static void installMplus(QueryWrapper<?> queryWrapper, Object searchObj, Map<String, String[]> parameterMap) {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)searchObj);
        Map<String, SysPermissionDataRuleModel> ruleMap = QueryGenerator.getRuleMap();
        for (String c : ruleMap.keySet()) {
            if (!oConvertUtils.isNotEmpty(c) || !c.startsWith(SQL_RULES_COLUMN)) continue;
            queryWrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.apply(QueryGenerator.getSqlRuleValue(((SysPermissionDataRuleModel)ruleMap.get(c)).getRuleValue()), new Object[0]);
            });
        }
        for (int i2 = 0; i2 < origDescriptors.length; ++i2) {
            String name = origDescriptors[i2].getName();
            String type = origDescriptors[i2].getPropertyType().toString();
            try {
                if (QueryGenerator.judgedIsUselessField(name) || !PropertyUtils.isReadable((Object)searchObj, (String)name)) continue;
                Object value = PropertyUtils.getSimpleProperty((Object)searchObj, (String)name);
                try {
                    TableField tableField;
                    Field field;
                    if (oConvertUtils.isNotEmpty(value) && (field = searchObj.getClass().getDeclaredField(name)) != null && (tableField = field.getAnnotation(TableField.class)) != null && !tableField.exist()) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ruleMap.containsKey(name)) {
                    QueryGenerator.addRuleToQueryWrapper(ruleMap.get(name), name, origDescriptors[i2].getPropertyType(), queryWrapper);
                }
                String endValue = null;
                String beginValue = null;
                if (parameterMap != null && parameterMap.containsKey(name + BEGIN)) {
                    beginValue = parameterMap.get(name + BEGIN)[0].trim();
                    QueryGenerator.addQueryByRule(queryWrapper, name, type, beginValue, QueryRuleEnum.GE);
                }
                if (parameterMap != null && parameterMap.containsKey(name + END)) {
                    endValue = parameterMap.get(name + END)[0].trim();
                    QueryGenerator.addQueryByRule(queryWrapper, name, type, endValue, QueryRuleEnum.LE);
                }
                if (parameterMap != null && parameterMap.containsKey(name + MULTI)) {
                    endValue = parameterMap.get(name + MULTI)[0].trim();
                    QueryGenerator.addQueryByRule(queryWrapper, name.replace(MULTI, ""), type, endValue, QueryRuleEnum.IN);
                }
                if (null != value && value.toString().startsWith(COMMA) && value.toString().endsWith(COMMA)) {
                    String multiLikeval = value.toString().replace(",,", COMMA);
                    String[] vals = multiLikeval.substring(1, multiLikeval.length()).split(COMMA);
                    String field = oConvertUtils.camelToUnderline(name);
                    if (vals.length > 1) {
                        queryWrapper.and(j -> {
                            j = (QueryWrapper)j.like((Object)field, (Object)vals[0]);
                            for (int k = 1; k < vals.length; ++k) {
                                j = (QueryWrapper)((QueryWrapper)j.or()).like((Object)field, (Object)vals[k]);
                            }
                        });
                        continue;
                    }
                    queryWrapper.and(j -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)j.like((Object)field, (Object)vals[0]);
                    });
                    continue;
                }
                QueryRuleEnum rule = QueryGenerator.convert2Rule(value);
                value = QueryGenerator.replaceValue(rule, value);
                QueryGenerator.addEasyQuery(queryWrapper, name, rule, value);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap);
        QueryGenerator.doSuperQuery(queryWrapper, parameterMap);
    }

    public static void doMultiFieldsOrder(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap) {
        String column = null;
        String order = null;
        if (parameterMap != null && parameterMap.containsKey(ORDER_COLUMN)) {
            column = parameterMap.get(ORDER_COLUMN)[0];
        }
        if (parameterMap != null && parameterMap.containsKey(ORDER_TYPE)) {
            order = parameterMap.get(ORDER_TYPE)[0];
        }
        log.debug("\u6392\u5e8f\u89c4\u5219>>\u5217:" + column + ",\u6392\u5e8f\u65b9\u5f0f:" + order);
        if (oConvertUtils.isNotEmpty(column) && oConvertUtils.isNotEmpty(order)) {
            if (column.endsWith("_dictText")) {
                column = column.substring(0, column.lastIndexOf("_dictText"));
            }
            SqlInjectionUtil.filterContent(column);
            if (order.toUpperCase().indexOf(ORDER_TYPE_ASC) >= 0) {
                queryWrapper.orderByAsc((Object)oConvertUtils.camelToUnderline(column));
            } else {
                queryWrapper.orderByDesc((Object)oConvertUtils.camelToUnderline(column));
            }
        }
    }

    public static void doSuperQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap) {
        if (parameterMap != null && parameterMap.containsKey(SUPER_QUERY_PARAMS)) {
            String superQueryParams = parameterMap.get(SUPER_QUERY_PARAMS)[0];
            String superQueryMatchType = parameterMap.get(SUPER_QUERY_MATCH_TYPE) != null ? parameterMap.get(SUPER_QUERY_MATCH_TYPE)[0] : MatchTypeEnum.AND.getValue();
            MatchTypeEnum matchType = MatchTypeEnum.getByValue(superQueryMatchType);
            try {
                superQueryParams = URLDecoder.decode(superQueryParams, "UTF-8");
                List conditions = JSON.parseArray((String)superQueryParams, QueryCondition.class);
                if (conditions == null || conditions.size() == 0) {
                    return;
                }
                log.info("---\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570-->" + conditions.toString());
                queryWrapper.and(andWrapper -> {
                    for (int i = 0; i < conditions.size(); ++i) {
                        QueryCondition rule = (QueryCondition)conditions.get(i);
                        if (!oConvertUtils.isNotEmpty(rule.getField()) || !oConvertUtils.isNotEmpty(rule.getRule()) || !oConvertUtils.isNotEmpty(rule.getVal())) continue;
                        log.debug("SuperQuery ==> " + rule.toString());
                        QueryGenerator.addEasyQuery(andWrapper, rule.getField(), QueryRuleEnum.getByValue(rule.getRule()), rule.getVal());
                        if (MatchTypeEnum.OR != matchType || i >= conditions.size() - 1) continue;
                        andWrapper.or();
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570\u8f6c\u7801\u5931\u8d25\uff1a" + superQueryParams, (Throwable)e);
            }
            catch (Exception e) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u62fc\u63a5\u5931\u8d25\uff1a" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static QueryRuleEnum convert2Rule(Object value) {
        if (value == null) {
            return null;
        }
        String val = (value + "").toString().trim();
        if (val.length() == 0) {
            return null;
        }
        QueryRuleEnum rule = null;
        if (rule == null && val.length() >= 3 && QUERY_SEPARATE_KEYWORD.equals(val.substring(2, 3))) {
            rule = QueryRuleEnum.getByValue(val.substring(0, 2));
        }
        if (rule == null && val.length() >= 2 && QUERY_SEPARATE_KEYWORD.equals(val.substring(1, 2))) {
            rule = QueryRuleEnum.getByValue(val.substring(0, 1));
        }
        if (rule == null && val.contains(STAR)) {
            if (val.startsWith(STAR) && val.endsWith(STAR)) {
                rule = QueryRuleEnum.LIKE;
            } else if (val.startsWith(STAR)) {
                rule = QueryRuleEnum.LEFT_LIKE;
            } else if (val.endsWith(STAR)) {
                rule = QueryRuleEnum.RIGHT_LIKE;
            }
        }
        if (rule == null && val.contains(COMMA)) {
            rule = QueryRuleEnum.IN;
        }
        if (rule == null && val.startsWith(NOT_EQUAL)) {
            rule = QueryRuleEnum.NE;
        }
        return rule != null ? rule : QueryRuleEnum.EQ;
    }

    private static Object replaceValue(QueryRuleEnum rule, Object value) {
        if (rule == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String val = (value + "").toString().trim();
        if (rule == QueryRuleEnum.LIKE) {
            value = val.substring(1, val.length() - 1);
        } else if (rule == QueryRuleEnum.LEFT_LIKE || rule == QueryRuleEnum.NE) {
            value = val.substring(1);
        } else if (rule == QueryRuleEnum.RIGHT_LIKE) {
            value = val.substring(0, val.length() - 1);
        } else if (rule == QueryRuleEnum.IN) {
            value = val.split(COMMA);
        } else if (val.startsWith(rule.getValue())) {
            value = val.replaceFirst(rule.getValue(), "");
        } else if (val.startsWith(rule.getCondition() + QUERY_SEPARATE_KEYWORD)) {
            value = val.replaceFirst(rule.getCondition() + QUERY_SEPARATE_KEYWORD, "").trim();
        }
        return value;
    }

    private static void addQueryByRule(QueryWrapper<?> queryWrapper, String name, String type, String value, QueryRuleEnum rule) throws ParseException {
        if (oConvertUtils.isNotEmpty(value)) {
            Object temp;
            if (value.indexOf(COMMA) != -1) {
                String temp2 = value;
                QueryGenerator.addEasyQuery(queryWrapper, name, rule, temp2);
                return;
            }
            switch (type) {
                case "class java.lang.Integer": {
                    temp = Integer.parseInt(value);
                    break;
                }
                case "class java.math.BigDecimal": {
                    temp = new BigDecimal(value);
                    break;
                }
                case "class java.lang.Short": {
                    temp = Short.parseShort(value);
                    break;
                }
                case "class java.lang.Long": {
                    temp = Long.parseLong(value);
                    break;
                }
                case "class java.lang.Float": {
                    temp = Float.valueOf(Float.parseFloat(value));
                    break;
                }
                case "class java.lang.Double": {
                    temp = Double.parseDouble(value);
                    break;
                }
                case "class java.util.Date": {
                    temp = QueryGenerator.getDateQueryByRule(value, rule);
                    break;
                }
                default: {
                    temp = value;
                }
            }
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, temp);
        }
    }

    private static Date getDateQueryByRule(String value, QueryRuleEnum rule) throws ParseException {
        Date date = null;
        if (value.length() == 10) {
            if (rule == QueryRuleEnum.GE) {
                date = QueryGenerator.getTime().parse(value + " 00:00:00");
            } else if (rule == QueryRuleEnum.LE) {
                date = QueryGenerator.getTime().parse(value + " 23:59:59");
            }
        }
        if (date == null) {
            date = QueryGenerator.getTime().parse(value);
        }
        return date;
    }

    private static void addEasyQuery(QueryWrapper<?> queryWrapper, String name, QueryRuleEnum rule, Object value) {
        if (value == null || rule == null || oConvertUtils.isEmpty(value)) {
            return;
        }
        name = oConvertUtils.camelToUnderline(name);
        log.info("--\u67e5\u8be2\u89c4\u5219-->" + name + QUERY_SEPARATE_KEYWORD + rule.getValue() + QUERY_SEPARATE_KEYWORD + value);
        switch (rule) {
            case GT: {
                queryWrapper.gt((Object)name, value);
                break;
            }
            case GE: {
                queryWrapper.ge((Object)name, value);
                break;
            }
            case LT: {
                queryWrapper.lt((Object)name, value);
                break;
            }
            case LE: {
                queryWrapper.le((Object)name, value);
                break;
            }
            case EQ: {
                queryWrapper.eq((Object)name, value);
                break;
            }
            case NE: {
                queryWrapper.ne((Object)name, value);
                break;
            }
            case IN: {
                if (value instanceof String) {
                    queryWrapper.in((Object)name, (Object[])value.toString().split(COMMA));
                    break;
                }
                if (value instanceof String[]) {
                    queryWrapper.in((Object)name, (Object[])value);
                    break;
                }
                if (value.getClass().isArray()) {
                    queryWrapper.in((Object)name, (Object[])value);
                    break;
                }
                queryWrapper.in((Object)name, new Object[]{value});
                break;
            }
            case LIKE: {
                queryWrapper.like((Object)name, value);
                break;
            }
            case LEFT_LIKE: {
                queryWrapper.likeLeft((Object)name, value);
                break;
            }
            case RIGHT_LIKE: {
                queryWrapper.likeRight((Object)name, value);
                break;
            }
            default: {
                log.info("--\u67e5\u8be2\u89c4\u5219\u672a\u5339\u914d\u5230---");
            }
        }
    }

    private static boolean judgedIsUselessField(String name) {
        return "class".equals(name) || "ids".equals(name) || "page".equals(name) || "rows".equals(name) || "sort".equals(name) || ORDER_TYPE.equals(name);
    }

    public static Map<String, SysPermissionDataRuleModel> getRuleMap() {
        HashMap<String, SysPermissionDataRuleModel> ruleMap = new HashMap<String, SysPermissionDataRuleModel>();
        List<SysPermissionDataRuleModel> list = JeecgDataAutorUtils.loadDataSearchConditon();
        if (list != null && list.size() > 0) {
            if (list.get(0) == null) {
                return ruleMap;
            }
            for (SysPermissionDataRuleModel rule : list) {
                String column = rule.getRuleColumn();
                if (QueryRuleEnum.SQL_RULES.getValue().equals(rule.getRuleConditions())) {
                    column = SQL_RULES_COLUMN + rule.getId();
                }
                ruleMap.put(column, rule);
            }
        }
        return ruleMap;
    }

    public static Map<String, SysPermissionDataRuleModel> getRuleMap(List<SysPermissionDataRuleModel> list) {
        HashMap<String, SysPermissionDataRuleModel> ruleMap = new HashMap<String, SysPermissionDataRuleModel>();
        if (list == null) {
            list = JeecgDataAutorUtils.loadDataSearchConditon();
        }
        if (list != null && list.size() > 0) {
            if (list.get(0) == null) {
                return ruleMap;
            }
            for (SysPermissionDataRuleModel rule : list) {
                String column = rule.getRuleColumn();
                if (QueryRuleEnum.SQL_RULES.getValue().equals(rule.getRuleConditions())) {
                    column = SQL_RULES_COLUMN + rule.getId();
                }
                ruleMap.put(column, rule);
            }
        }
        return ruleMap;
    }

    private static void addRuleToQueryWrapper(SysPermissionDataRuleModel dataRule, String name, Class propertyType, QueryWrapper<?> queryWrapper) {
        QueryRuleEnum rule = QueryRuleEnum.getByValue(dataRule.getRuleConditions());
        if (rule.equals((Object)QueryRuleEnum.IN) && !propertyType.equals(String.class)) {
            String[] values = dataRule.getRuleValue().split(COMMA);
            Object[] objs = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                objs[i] = NumberUtils.parseNumber((String)values[i], (Class)propertyType);
            }
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, objs);
        } else if (propertyType.equals(String.class)) {
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, QueryGenerator.converRuleValue(dataRule.getRuleValue()));
        } else if (propertyType.equals(Date.class)) {
            String dateStr = QueryGenerator.converRuleValue(dataRule.getRuleValue());
            if (dateStr.length() == 10) {
                QueryGenerator.addEasyQuery(queryWrapper, name, rule, DateUtils.str2Date(dateStr, DateUtils.date_sdf.get()));
            } else {
                QueryGenerator.addEasyQuery(queryWrapper, name, rule, DateUtils.str2Date(dateStr, DateUtils.datetimeFormat.get()));
            }
        } else {
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, NumberUtils.parseNumber((String)dataRule.getRuleValue(), (Class)propertyType));
        }
    }

    public static String converRuleValue(String ruleValue) {
        String value = JwtUtil.getUserSystemData(ruleValue, null);
        return value != null ? value : ruleValue;
    }

    public static String trimSingleQuote(String ruleValue) {
        if (oConvertUtils.isEmpty(ruleValue)) {
            return "";
        }
        if (ruleValue.startsWith(SQL_SQ)) {
            ruleValue = ruleValue.substring(1);
        }
        if (ruleValue.endsWith(SQL_SQ)) {
            ruleValue = ruleValue.substring(0, ruleValue.length() - 1);
        }
        return ruleValue;
    }

    public static String getSqlRuleValue(String sqlRule) {
        try {
            Set<String> varParams = QueryGenerator.getSqlRuleParams(sqlRule);
            for (String var : varParams) {
                String tempValue = QueryGenerator.converRuleValue(var);
                sqlRule = sqlRule.replace("#{" + var + "}", tempValue);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sqlRule;
    }

    public static Set<String> getSqlRuleParams(String sql) {
        if (oConvertUtils.isEmpty(sql)) {
            return null;
        }
        HashSet<String> varParams = new HashSet<String>();
        String regex = "\\#\\{\\w+\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            String var = m.group();
            varParams.add(var.substring(var.indexOf("{") + 1, var.indexOf("}")));
        }
        return varParams;
    }

    public static String getSingleQueryConditionSql(String field, String alias, Object value, boolean isString) {
        if (value == null) {
            return "";
        }
        field = alias + oConvertUtils.camelToUnderline(field);
        QueryRuleEnum rule = QueryGenerator.convert2Rule(value);
        return QueryGenerator.getSingleSqlByRule(rule, field, value, isString);
    }

    public static String getSingleSqlByRule(QueryRuleEnum rule, String field, Object value, boolean isString) {
        String res = "";
        switch (rule) {
            case GT: {
                res = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case GE: {
                res = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case LT: {
                res = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case LE: {
                res = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case EQ: {
                res = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case NE: {
                res = field + " <> " + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case IN: {
                res = field + " in " + QueryGenerator.getInConditionValue(value, isString);
                break;
            }
            case LIKE: {
                res = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            case LEFT_LIKE: {
                res = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            case RIGHT_LIKE: {
                res = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            default: {
                res = field + " = " + QueryGenerator.getFieldConditionValue(value, isString);
            }
        }
        return res;
    }

    private static String getFieldConditionValue(Object value, boolean isString) {
        String str = value.toString().trim();
        if (str.startsWith(NOT_EQUAL)) {
            str = str.substring(1);
        } else if (str.startsWith(">=")) {
            str = str.substring(2);
        } else if (str.startsWith("<=")) {
            str = str.substring(2);
        } else if (str.startsWith(">")) {
            str = str.substring(1);
        } else if (str.startsWith("<")) {
            str = str.substring(1);
        }
        if (isString) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                return " N'" + str + "' ";
            }
            return " '" + str + "' ";
        }
        return value.toString();
    }

    private static String getInConditionValue(Object value, boolean isString) {
        if (isString) {
            String[] temp = value.toString().split(COMMA);
            String res = "";
            for (String string : temp) {
                res = "SQLSERVER".equals(QueryGenerator.getDbType()) ? res + ",N'" + string + SQL_SQ : res + ",'" + string + SQL_SQ;
            }
            return "(" + res.substring(1) + ")";
        }
        return "(" + value.toString() + ")";
    }

    private static String getLikeConditionValue(Object value) {
        String str = value.toString().trim();
        if (str.startsWith(STAR) && str.endsWith(STAR)) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                return "N'%" + str.substring(1, str.length() - 1) + "%'";
            }
            return "'%" + str.substring(1, str.length() - 1) + "%'";
        }
        if (str.startsWith(STAR)) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                return "N'%" + str.substring(1) + SQL_SQ;
            }
            return "'%" + str.substring(1) + SQL_SQ;
        }
        if (str.endsWith(STAR)) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                return "N'" + str.substring(0, str.length() - 1) + "%'";
            }
            return SQL_SQ + str.substring(0, str.length() - 1) + "%'";
        }
        if (str.indexOf("%") >= 0) {
            if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
                if (str.startsWith(SQL_SQ) && str.endsWith(SQL_SQ)) {
                    return "N" + str;
                }
                return "N'" + str + SQL_SQ;
            }
            if (str.startsWith(SQL_SQ) && str.endsWith(SQL_SQ)) {
                return str;
            }
            return SQL_SQ + str + SQL_SQ;
        }
        if ("SQLSERVER".equals(QueryGenerator.getDbType())) {
            return "N'%" + str + "%'";
        }
        return "'%" + str + "%'";
    }

    public static String installAuthJdbc(Class<?> clazz) {
        StringBuffer sb = new StringBuffer();
        Map<String, SysPermissionDataRuleModel> ruleMap = QueryGenerator.getRuleMap();
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors(clazz);
        String sql_and = " and ";
        for (String c : ruleMap.keySet()) {
            if (!oConvertUtils.isNotEmpty(c) || !c.startsWith(SQL_RULES_COLUMN)) continue;
            sb.append(sql_and + QueryGenerator.getSqlRuleValue(ruleMap.get(c).getRuleValue()));
        }
        for (int i = 0; i < origDescriptors.length; ++i) {
            String name = origDescriptors[i].getName();
            if (QueryGenerator.judgedIsUselessField(name) || !ruleMap.containsKey(name)) continue;
            SysPermissionDataRuleModel dataRule = ruleMap.get(name);
            QueryRuleEnum rule = QueryRuleEnum.getByValue(dataRule.getRuleConditions());
            Class<?> propType = origDescriptors[i].getPropertyType();
            boolean isString = propType.equals(String.class);
            Object value = isString ? QueryGenerator.converRuleValue(dataRule.getRuleValue()) : NumberUtils.parseNumber((String)dataRule.getRuleValue(), propType);
            String filedSql = QueryGenerator.getSingleSqlByRule(rule, oConvertUtils.camelToUnderline(name), value, isString);
            sb.append(sql_and + filedSql);
        }
        log.info("query auth sql is:" + sb.toString());
        return sb.toString();
    }

    public static void installAuthMplus(QueryWrapper<?> queryWrapper, Class<?> clazz) {
        Map<String, SysPermissionDataRuleModel> ruleMap = QueryGenerator.getRuleMap();
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors(clazz);
        for (String c : ruleMap.keySet()) {
            if (!oConvertUtils.isNotEmpty(c) || !c.startsWith(SQL_RULES_COLUMN)) continue;
            queryWrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.apply(QueryGenerator.getSqlRuleValue(((SysPermissionDataRuleModel)ruleMap.get(c)).getRuleValue()), new Object[0]);
            });
        }
        for (int i2 = 0; i2 < origDescriptors.length; ++i2) {
            String name = origDescriptors[i2].getName();
            if (QueryGenerator.judgedIsUselessField(name) || !ruleMap.containsKey(name)) continue;
            QueryGenerator.addRuleToQueryWrapper(ruleMap.get(name), name, origDescriptors[i2].getPropertyType(), queryWrapper);
        }
    }

    public static String convertSystemVariables(String sql) {
        return QueryGenerator.getSqlRuleValue(sql);
    }

    public static String getAllConfigAuth() {
        StringBuffer sb = new StringBuffer();
        Map<String, SysPermissionDataRuleModel> ruleMap = QueryGenerator.getRuleMap();
        String sql_and = " and ";
        for (String c : ruleMap.keySet()) {
            SysPermissionDataRuleModel dataRule = ruleMap.get(c);
            String ruleValue = dataRule.getRuleValue();
            if (oConvertUtils.isEmpty(ruleValue)) continue;
            if (oConvertUtils.isNotEmpty(c) && c.startsWith(SQL_RULES_COLUMN)) {
                sb.append(sql_and + QueryGenerator.getSqlRuleValue(ruleValue));
                continue;
            }
            boolean isString = false;
            if ((ruleValue = ruleValue.trim()).startsWith(SQL_SQ) && ruleValue.endsWith(SQL_SQ)) {
                isString = true;
                ruleValue = ruleValue.substring(1, ruleValue.length() - 1);
            }
            QueryRuleEnum rule = QueryRuleEnum.getByValue(dataRule.getRuleConditions());
            String value = QueryGenerator.converRuleValue(ruleValue);
            String filedSql = QueryGenerator.getSingleSqlByRule(rule, c, value, isString);
            sb.append(sql_and + filedSql);
        }
        log.info("query auth sql is = " + sb.toString());
        return sb.toString();
    }

    private static String getDbType() {
        return CommonUtils.getDatabaseType();
    }
}

