/*
 * Decompiled with CFR 0.152.
 */
package com.mxp.profileimagecropper;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.mxp.profileimagecropper.ProfileImageCropper;
import com.mxp.profileimagecropper.R;
import com.squareup.picasso.Picasso;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ProfileImageCropperActivity
extends AppCompatActivity {
    private static final int PICK_IMAGE_FROM_GALLERY = 9000;
    private static final String TAG = "ProfileImageCropperAct";
    ProfileImageCropper image = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_profile_image_cropper);
        this.image = (ProfileImageCropper)this.findViewById(R.id.profileImage);
        this.applyIntent(this.getIntent());
        this.initLoadNewButton();
        this.initCropImage();
        this.initDoneButton();
    }

    protected void onResume() {
        super.onResume();
        this.applyIntent(this.getIntent());
    }

    private void applyIntent(Intent intent) {
        int value = 0;
        String valueStr = "";
        value = intent.getIntExtra("cropperBackground", -1);
        if (value != -1) {
            this.image.setCropperBackground(value);
        }
        if ((value = intent.getIntExtra("cropperBorder", -1)) != -1) {
            this.image.setCropperBorder(value);
        }
        if ((value = intent.getIntExtra("cropperBorderWidth", -1)) != -1) {
            this.image.setCropperBorderWidth(value);
        }
        if ((value = intent.getIntExtra("cropperWidth", -1)) != -1) {
            this.image.setCropperWidth(value);
        }
        if ((value = intent.getIntExtra("cropperMinimumWidth", -1)) != -1) {
            this.image.setCropperMinimumWidth(value);
        }
        if ((value = intent.getIntExtra("handleBackground", -1)) != -1) {
            this.image.setHandleBackground(value);
        }
        if ((value = intent.getIntExtra("handleBorder", -1)) != -1) {
            this.image.setHandleBorder(value);
        }
        if ((value = intent.getIntExtra("handleBorderWidth", -1)) != -1) {
            this.image.setHandleBorderWidth(value);
        }
        if ((value = intent.getIntExtra("handleWidth", -1)) != -1) {
            this.image.setHandleWidth(value);
        }
        if ((value = intent.getIntExtra("background", -1)) != -1) {
            this.image.setBackgroundColor(value);
        }
        if ((value = intent.getIntExtra("controlBackground", -1)) != -1) {
            ((LinearLayout)this.findViewById(R.id.layout_controls)).setBackgroundColor(value);
        }
    }

    private void initLoadNewButton() {
        ((Button)this.findViewById(R.id.loadNew)).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    Intent intent = new Intent();
                    intent.setType("image/*");
                    intent.setAction("android.intent.action.GET_CONTENT");
                    ProfileImageCropperActivity.this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select Picture"), 9000);
                }
                catch (Exception e) {
                    Snackbar.make((View)view, (CharSequence)e.getMessage(), (int)0).setActionTextColor(ProfileImageCropperActivity.this.getResources().getColor(0x1060001)).show();
                }
            }
        });
    }

    private void initCropImage() {
        ((Button)this.findViewById(R.id.cropImage)).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    Bitmap bmp = ((ProfileImageCropper)ProfileImageCropperActivity.this.findViewById(R.id.profileImage)).crop();
                    ProfileImageCropperActivity.this.image.setEditMode(false);
                    ProfileImageCropperActivity.this.image.setImageBitmap(bmp);
                }
                catch (Exception e) {
                    Snackbar.make((View)view, (CharSequence)e.getMessage(), (int)0).setActionTextColor(ProfileImageCropperActivity.this.getResources().getColor(0x1060001)).show();
                }
            }
        });
    }

    private void initDoneButton() {
        ((Button)this.findViewById(R.id.done)).setOnClickListener(new View.OnClickListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick(View view) {
                Intent intent = new Intent();
                try {
                    Bitmap bitmap = ((BitmapDrawable)ProfileImageCropperActivity.this.image.getDrawable()).getBitmap();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
                    byte[] b = bos.toByteArray();
                    String tmpFilename = "tmp_cropped_image.png";
                    File f = File.createTempFile("tmp_", ".png");
                    tmpFilename = f.getAbsolutePath();
                    FileOutputStream fileOutStream = new FileOutputStream(tmpFilename);
                    fileOutStream.write(b);
                    fileOutStream.close();
                    intent.putExtra("result", tmpFilename);
                    ProfileImageCropperActivity.this.setResult(-1, intent);
                }
                catch (Exception e) {
                    intent.putExtra("exception", e.getMessage());
                    ProfileImageCropperActivity.this.setResult(-1, intent);
                }
                finally {
                    ProfileImageCropperActivity.this.finish();
                }
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 9000 && resultCode == -1) {
            if (data == null) {
                return;
            }
            try {
                Picasso.with((Context)this.getBaseContext()).load(data.getData()).fit().centerInside().into((ImageView)this.image);
                this.image.setEditMode(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

