/*
 * Decompiled with CFR 0.152.
 */
package com.mxp.profileimagecropper;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.support.v4.view.MotionEventCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.ImageView;
import com.mxp.profileimagecropper.R;

public class ProfileImageCropper
extends ImageView {
    private static final String TAG = "ProfileImageSizer";
    private static final int INVALID_POINTER_ID = -1;
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HANDLE_WIDTH = 50;
    private static final int DEFAULT_MIN_WIDTH = 200;
    private int cropperBackground = -4774323;
    private int cropperBorder = -1715928903;
    private int cropperBorderWidth = 5;
    private int cropperWidth = 350;
    private int handleBackground = -1728053248;
    private int handleBorder = -1728053248;
    private int handleBorderWidth = 2;
    private int handleWidth = 50;
    private int cropperMinimumWidth = 200;
    Rect cropperBounds = new Rect(0, 0, 350, 350);
    Rect handleBounds = new Rect(0, 0, 50, 50);
    private int mActivePointerId = -1;
    private float mLastTouchX;
    private float mLastTouchY;
    private float mPosX;
    private float mPosY;
    private boolean inside = false;
    private boolean insideHandle = false;
    private boolean editMode = false;
    private boolean drawBorder = false;
    private Rect imageBorder;

    public ProfileImageCropper(Context context) {
        super(context);
        this.initDragListener();
    }

    private void initDragListener() {
    }

    public ProfileImageCropper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initImage(attrs);
    }

    public ProfileImageCropper(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initImage(attrs);
    }

    @TargetApi(value=21)
    public ProfileImageCropper(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initImage(attrs);
    }

    private void initImage(AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ProfileImageCropper, 0, 0);
        try {
            this.setCropperBackground(a.getColor(R.styleable.ProfileImageCropper_cropperBackground, -4774323));
            this.setCropperBorder(a.getInteger(R.styleable.ProfileImageCropper_cropperBorder, -1715928903));
            this.setCropperBorderWidth((int)a.getDimension(R.styleable.ProfileImageCropper_cropperBorderWidth, 5.0f));
            this.setCropperWidth((int)a.getDimension(R.styleable.ProfileImageCropper_cropperWidth, 350.0f));
            this.setCropperMinimumWidth((int)a.getDimension(R.styleable.ProfileImageCropper_cropperMinimumWidth, 200.0f));
            if (this.cropperWidth < this.cropperMinimumWidth) {
                this.cropperWidth = this.cropperMinimumWidth;
            }
            this.setHandleBackground(a.getColor(R.styleable.ProfileImageCropper_handleBackground, -1728053248));
            this.setHandleBorder(a.getInteger(R.styleable.ProfileImageCropper_handleBorder, -1728053248));
            this.setHandleBorderWidth((int)a.getDimension(R.styleable.ProfileImageCropper_handleBorderWidth, 2.0f));
            this.setHandleWidth((int)a.getDimension(R.styleable.ProfileImageCropper_handleWidth, 50.0f));
            this.setEditMode(a.getBoolean(R.styleable.ProfileImageCropper_editMode, true));
            this.cropperBounds.right = this.cropperWidth;
            this.cropperBounds.bottom = this.cropperWidth;
        }
        finally {
            a.recycle();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int[] points = this.getBitmapPositionInsideImageView(this);
        this.imageBorder = new Rect(points[0], points[1], points[0] + points[2], points[1] + points[3]);
        if (!this.editMode) {
            return;
        }
        ShapeDrawable shape = new ShapeDrawable((Shape)new RectShape());
        shape.getPaint().setStyle(Paint.Style.FILL);
        shape.setBounds(this.cropperBounds);
        shape.getPaint().setColor(this.cropperBackground);
        shape.draw(canvas);
        shape.getPaint().setStyle(Paint.Style.STROKE);
        shape.getPaint().setColor(this.cropperBorder);
        shape.getPaint().setStrokeWidth((float)this.cropperBorderWidth);
        shape.draw(canvas);
        ShapeDrawable shape2 = new ShapeDrawable((Shape)new OvalShape());
        this.handleBounds.left = this.cropperBounds.right - this.handleWidth / 2;
        this.handleBounds.right = this.handleBounds.left + this.handleWidth;
        this.handleBounds.top = this.cropperBounds.bottom - this.handleWidth / 2;
        this.handleBounds.bottom = this.handleBounds.top + this.handleWidth;
        shape2.setBounds(this.handleBounds);
        shape2.getPaint().setStyle(Paint.Style.FILL);
        shape2.getPaint().setColor(this.handleBackground);
        shape2.getPaint().setStrokeWidth((float)this.handleBorderWidth);
        shape2.draw(canvas);
        shape2.getPaint().setStyle(Paint.Style.STROKE);
        shape2.getPaint().setColor(this.handleBorder);
        shape2.getPaint().setStrokeWidth((float)this.handleBorderWidth);
        shape2.draw(canvas);
        if (this.drawBorder) {
            ShapeDrawable shape3 = new ShapeDrawable((Shape)new RectShape());
            shape3.setBounds(this.imageBorder);
            shape3.getPaint().setStyle(Paint.Style.STROKE);
            shape3.getPaint().setColor(-65536);
            shape3.getPaint().setStrokeWidth(15.0f);
            shape3.draw(canvas);
        }
    }

    public Bitmap crop() {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        if (this.getDrawable() == null) {
            throw new IllegalStateException("No drawable set!");
        }
        Rect tmpr = new Rect(this.cropperBounds);
        if (tmpr.left < this.imageBorder.left) {
            tmpr.left = this.imageBorder.left;
        }
        if (tmpr.right > this.imageBorder.right) {
            tmpr.right = this.imageBorder.right;
        }
        if (tmpr.top < this.imageBorder.top) {
            tmpr.top = this.imageBorder.top;
        }
        if (tmpr.bottom > this.imageBorder.bottom) {
            tmpr.bottom = this.imageBorder.bottom;
        }
        this.logRect(this.imageBorder, "imageBorder");
        this.logRect(tmpr, "cropperBounds");
        int renderedWidth = this.imageBorder.right - this.imageBorder.left;
        int renderedHeight = this.imageBorder.bottom - this.imageBorder.top;
        float percX = ((float)tmpr.left - (float)this.imageBorder.left) / ((float)this.imageBorder.right - (float)this.imageBorder.left);
        float percY = ((float)tmpr.top - (float)this.imageBorder.top) / ((float)this.imageBorder.bottom - (float)this.imageBorder.top);
        float percW = ((float)tmpr.right - (float)tmpr.left) / ((float)this.imageBorder.right - (float)this.imageBorder.left);
        float percH = ((float)tmpr.bottom - (float)tmpr.top) / ((float)this.imageBorder.bottom - (float)this.imageBorder.top);
        Log.d((String)TAG, (String)("percX: " + percX + "%, perxY: " + percY + "%, percW: " + percW + "%, perxH: " + percH + "%"));
        Bitmap bmp = ((BitmapDrawable)this.getDrawable()).getBitmap();
        BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
        bitmapOptions.inDensity = bmp.getDensity();
        bitmapOptions.inTargetDensity = 1;
        bmp.setDensity(0);
        Rect finalCut = new Rect();
        finalCut.left = (int)(percX * (float)bmp.getWidth());
        finalCut.top = (int)(percY * (float)bmp.getHeight());
        finalCut.right = (int)(percW * (float)bmp.getWidth());
        finalCut.bottom = (int)(percH * (float)bmp.getHeight());
        Log.d((String)TAG, (String)("image WxH: " + this.getWidth() + "x" + this.getHeight() + ", bmp WxH: " + bmp.getWidth() + "x" + bmp.getHeight()));
        this.logRect(finalCut, "finalcut");
        Log.d((String)TAG, (String)("percW: " + percW + " - percW/imageBorder.Width (" + percW + "*" + (this.imageBorder.right - this.imageBorder.left) + "): " + percW * (float)(this.imageBorder.right - this.imageBorder.left)));
        Log.d((String)TAG, (String)("finalCut.width: " + (finalCut.right - finalCut.left) + " - finalCut.width/bmp.Width (" + (finalCut.right - finalCut.left) + "*" + bmp.getWidth() + "): " + (finalCut.right - finalCut.left) * bmp.getWidth()));
        Bitmap bmp2 = Bitmap.createBitmap((Bitmap)bmp, (int)finalCut.left, (int)finalCut.top, (int)finalCut.right, (int)finalCut.bottom);
        return bmp2;
    }

    private boolean isTouchInside(Rect bounds, Point point) {
        return this.isTouchInside(bounds, point.x, point.y);
    }

    private boolean isTouchInside(Rect bounds, int x, int y) {
        return bounds.left < x && x < bounds.right && bounds.top < y && y < bounds.bottom;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.editMode) {
            return super.onTouchEvent(event);
        }
        this.inside = this.isTouchInside(this.cropperBounds, (int)event.getX(), (int)event.getY());
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        switch (action) {
            case 0: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
                float x = MotionEventCompat.getX((MotionEvent)event, (int)pointerIndex);
                float y = MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)0);
                this.insideHandle = this.isTouchInside(this.handleBounds, (int)event.getX(), (int)event.getY());
                break;
            }
            case 2: {
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)this.mActivePointerId);
                float x = MotionEventCompat.getX((MotionEvent)event, (int)pointerIndex);
                float y = MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
                float dx = x - this.mLastTouchX;
                float dy = y - this.mLastTouchY;
                if (!this.insideHandle) {
                    if (this.mPosX + dx >= 0.0f && this.mPosX + dx <= (float)(this.getWidth() - this.cropperWidth)) {
                        this.mPosX += dx;
                    }
                    if (this.mPosY + dy >= 0.0f && this.mPosY + dy <= (float)(this.getHeight() - this.cropperWidth)) {
                        this.mPosY += dy;
                    }
                } else if (!((float)this.cropperWidth + dx < (float)this.cropperMinimumWidth)) {
                    this.cropperWidth = (int)((float)this.cropperWidth + dx);
                }
                this.cropperBounds.left = (int)this.mPosX;
                this.cropperBounds.top = (int)this.mPosY;
                this.cropperBounds.right = this.cropperBounds.left + this.cropperWidth;
                this.cropperBounds.bottom = this.cropperBounds.top + this.cropperWidth;
                this.invalidate();
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                break;
            }
            case 1: {
                this.mActivePointerId = -1;
                this.insideHandle = false;
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                this.insideHandle = false;
                break;
            }
            case 6: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)pointerIndex);
                if (pointerId == this.mActivePointerId) {
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.mLastTouchX = MotionEventCompat.getX((MotionEvent)event, (int)newPointerIndex);
                    this.mLastTouchY = MotionEventCompat.getY((MotionEvent)event, (int)newPointerIndex);
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)newPointerIndex);
                }
                this.insideHandle = false;
                break;
            }
        }
        return true;
    }

    private int[] getBitmapPositionInsideImageView(ImageView imageView) {
        int left;
        int[] ret = new int[4];
        if (imageView == null || imageView.getDrawable() == null) {
            return ret;
        }
        float[] f = new float[9];
        imageView.getImageMatrix().getValues(f);
        float scaleX = f[0];
        float scaleY = f[4];
        Drawable d = imageView.getDrawable();
        int origW = d.getIntrinsicWidth();
        int origH = d.getIntrinsicHeight();
        int actW = Math.round((float)origW * scaleX);
        int actH = Math.round((float)origH * scaleY);
        ret[2] = actW;
        ret[3] = actH;
        int imgViewW = imageView.getWidth();
        int imgViewH = imageView.getHeight();
        int top = (imgViewH - actH) / 2;
        ret[0] = left = (imgViewW - actW) / 2;
        ret[1] = top;
        return ret;
    }

    private void logRect(Rect r, String name) {
        if (r != null) {
            Log.d((String)TAG, (String)("Rect (" + name + "): [" + r.left + "," + r.top + "] [" + r.right + "," + r.bottom + "]" + " " + "WxH: " + (r.right - r.left) + "x" + (r.bottom - r.top)));
        }
    }

    public int getCropperBackground() {
        return this.cropperBackground;
    }

    public void setCropperBackground(int cropperBackground) {
        this.cropperBackground = cropperBackground;
    }

    public int getCropperBorder() {
        return this.cropperBorder;
    }

    public void setCropperBorder(int cropperBorder) {
        this.cropperBorder = cropperBorder;
    }

    public int getCropperBorderWidth() {
        return this.cropperBorderWidth;
    }

    public void setCropperBorderWidth(int cropperBorderWidth) {
        this.cropperBorderWidth = cropperBorderWidth;
    }

    public int getHandleBackground() {
        return this.handleBackground;
    }

    public void setHandleBackground(int handleBackground) {
        this.handleBackground = handleBackground;
    }

    public int getHandleBorder() {
        return this.handleBorder;
    }

    public void setHandleBorder(int handleBorder) {
        this.handleBorder = handleBorder;
    }

    public int getHandleBorderWidth() {
        return this.handleBorderWidth;
    }

    public void setHandleBorderWidth(int handleBorderWidth) {
        this.handleBorderWidth = handleBorderWidth;
    }

    public int getCropperWidth() {
        return this.cropperWidth;
    }

    public void setCropperWidth(int cropperWidth) {
        this.cropperWidth = cropperWidth;
        this.cropperBounds.right = this.cropperBounds.left + cropperWidth;
        this.cropperBounds.bottom = this.cropperBounds.top + cropperWidth;
        this.invalidate();
    }

    public int getHandleWidth() {
        return this.handleWidth;
    }

    public void setHandleWidth(int handleWidth) {
        this.handleWidth = handleWidth;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        this.invalidate();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.invalidate();
    }

    public int getCropperMinimumWidth() {
        return this.cropperMinimumWidth;
    }

    public void setCropperMinimumWidth(int cropperMinimumWidth) {
        this.cropperMinimumWidth = cropperMinimumWidth;
    }
}

