package com.mxchip.mx_log_dingtalk.uncaughtHandler

import android.content.Context
import android.content.Intent
import com.mxchip.mx_log_dingtalk.dingtalk.DingTalkReport
import com.mxchip.mx_log_dingtalk.dingtalk.DingTalkReporterService
import com.mxchip.mx_log_dingtalk.info.collectDeviceInfo
import java.io.ByteArrayOutputStream
import java.io.PrintStream
import java.text.SimpleDateFormat
import java.util.*

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/26
 * @time: 2:18 PM
 * @desc:
 */
class DefaultCrashHandler: ICrashHandler {

    val TAG = "MXCHIP.DefaultCrashHandler"

    private lateinit var mDefaultCrashHandler: Thread.UncaughtExceptionHandler
    private lateinit var mContext: Context

    private val dateFormatter = SimpleDateFormat("yyyy-MM-dd HH:mm:ss")

    override fun init(context: Context, token: String, keyword: Array<String>) {
        mContext = context
        mDefaultCrashHandler = Thread.getDefaultUncaughtExceptionHandler()
        Thread.setDefaultUncaughtExceptionHandler(this)
        DingTalkReport.DINGTALK_TOKEN = token
        DingTalkReport.DINGTALK_KEYWORD = keyword
    }

    override fun dumpException(t: Thread?, e: Throwable?) {
        val keywordCount = DingTalkReport.DINGTALK_KEYWORD.size
        val random = (0 until keywordCount).random()
        val keyword = DingTalkReport.DINGTALK_KEYWORD[random]
        val time = dateFormatter.format(Date())
        val sb = StringBuffer()
        sb.append("$keyword\n")
        sb.append("$time\n")

        val deviceInfo = collectDeviceInfo(mContext)
        sb.append(deviceInfo)

        val baos = ByteArrayOutputStream()
        try {
            e?.printStackTrace(PrintStream(baos))
        } finally {
            baos.close()
        }
        sb.append(baos.toString())

        mContext.startService(Intent(mContext, DingTalkReporterService::class.java).apply {
            putExtra("info", sb.toString())
        })
    }

    override fun defaultExit(t: Thread?, e: Throwable?) {
        if (mDefaultCrashHandler != null) {
            mDefaultCrashHandler.uncaughtException(t, e)
        }
    }
}