package com.mxchip.interfaces;

import android.app.Activity;
import android.content.Context;
import android.widget.ImageView;

import com.mxchip.config.DisplayConfig;

import java.io.File;

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/19
 * @time: 5:00 PM
 * @desc:
 */
public interface IImageLoader {
    void display(ImageView imageView, String url);

    void display(ImageView imageView, String url, int radius);

    void display(ImageView imageView, String url, int radius, int direction);

    void display(ImageView imageView, String url, DisplayConfig config);

    void display(Activity activity, ImageView imageView, String url);

    void display(Activity activity, ImageView imageView, String url, DisplayConfig config);

    void display(Activity activity, ImageView imageView, String url, int radius);

    void display(Activity activity, ImageView imageView, String url, int radius, int direction);

    void display(ImageView imageView, int resId);

    void display(ImageView imageView, int resId, int radius);

    void display(ImageView imageView, int resId, int radius, int direction);

    void display(ImageView imageView, int resId, DisplayConfig config);

    void display(Activity activity, ImageView imageView, int resId);

    void display(Activity activity, ImageView imageView, int resId, DisplayConfig op);

    void display(Activity activity, ImageView imageView, int resId, int radius);

    void display(Activity activity, ImageView imageView, int resId, int radius, int direction);

    void display(ImageView imageView, File file);

    void display(ImageView imageView, File file, DisplayConfig op);

    void display(ImageView imageView, File file, int radius);

    void display(ImageView imageView, File file, int radius, int direction);

    void display(Activity activity, ImageView imageView, File file);

    void display(Activity activity, ImageView imageView, File file, DisplayConfig op);

    void display(Activity activity, ImageView imageView, File file, int radius);

    void display(Activity activity, ImageView imageView, File file, int radius, int direction);

    void startGif(ImageView imageView);

    void stopGif(ImageView imageView);

    void recycleGif(ImageView imageView);

    void cancel(ImageView imageView);

    void pauseRequest();

    void resumeRequest();

    void clearMemoryCache();

    void clearDiskCache();

    void onTrimMemory(int level);

    void onLowMemory();

    void init(Context context);

    void release();
}
