package com.mxchip.config;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;


import androidx.annotation.IdRes;

import static com.mxchip.config.RadiusConfig.RadiusAll;

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/18
 * @time: 4:32 PM
 * @desc:
 */
public class DisplayConfig {

    private DisplayConfig(Builder builder) {
        mCacheOnDisc = builder.mCacheOnDisc;
        mCacheInMemory = builder.mCacheInMemory;
        mBitmapConfig = builder.mBitmapConfig;
        mBackgroundColor = builder.mBackgroundColor;
        mRadius = builder.mRadius;
        mRadiusDirection = builder.mRadiusDirection;
        mLoadingImageResId = builder.mLoadingImageResId;
        mLoadingImageDrawable = builder.mLoadingImageDrawable;
        mLoadErrorImageResId = builder.mLoadErrorImageResId;
        mLoadErrorImage = builder.mLoadErrorImage;
        mScaleType = builder.mScaleType;
        mEffect = builder.mEffect;
        mEffectOutputView = builder.mEffectOutputView;
        mThumbnail = builder.mThumbnail;
        mAnimationResId = builder.mAnimationResId;
        mGifLoopCount = builder.mGifLoopCount;
        mIsGif = builder.mIsGif;
        resizeWidth = builder.resizeWidth;
        resizeHeight = builder.resizeHeight;
        mPreLoad = builder.mPreLoad;
        mBlurRadius = builder.mBlurRadius;
        mBlurSample = builder.mBlurSample;

    }


    /**
     * 是否磁盘缓存
     */
    private boolean mCacheOnDisc = true;
    /**
     * 是否内存缓存
     */
    private boolean mCacheInMemory = true;
    /**
     * bitmap格式设置，RGB8888、RGB656
     * 默认使用RGB_565，减少内存开销
     */
    private Bitmap.Config mBitmapConfig = Bitmap.Config.RGB_565;
    /**
     * 默认背景色，当RGB_565模式的时候，因为没有透明度，透明部分填充这个背景色
     */
    private int mBackgroundColor = Color.WHITE;

    /**
     * 圆角
     */
    private int mRadius = 0;

    /**
     * 圆角方向
     * 默认四个角都设置圆角
     */
    private int mRadiusDirection = RadiusAll;

    /**
     * 加载中图片id
     */
    private @IdRes int mLoadingImageResId = -1;

    /**
     * 加载中图片
     */
    private Drawable mLoadingImageDrawable;

    /**
     * 加载失败图片id
     */
    private @IdRes int mLoadErrorImageResId = -1;

    /**
     * 加载失败图片
     */
    private Drawable mLoadErrorImage;

    /**
     * Image在ImageView中的显示方式
     */
    private ScaleTypeConfig mScaleType = ScaleTypeConfig.CenterCrop;

    /**
     * Image显示特效
     * 灰阶，高斯模糊等
     */
    private int mEffect = SpecialEffectConfig.None;

    /**
     * 将bitmap输出到这个view的背景上
     */
    private View mEffectOutputView;

    /**
     * 显示缩略图大小
     */
    private float mThumbnail = 0.0f;

    /**
     * 动画资源id
     */
    private int mAnimationResId = -1;

    /**
     * gif循环次数
     */
    private int mGifLoopCount = 0;

    /**
     * 是否为动画格式
     */
    private boolean mIsGif = false;

    /**
     * resize image 尺寸
     */
    private int resizeWidth = 0;
    private int resizeHeight = 0;

    /**
     * 是否预加载
     */
    private boolean mPreLoad = false;

    /**
     * 高斯模糊半径
     */
    private int mBlurRadius = 25;

    /**
     * 高斯模糊采样率
     */
    private int mBlurSample = 0;

    public boolean isCacheOnDisc() {
        return mCacheOnDisc;
    }

    public boolean isCacheInMemory() {
        return mCacheInMemory;
    }

    public Bitmap.Config getBitmapConfig() {
        return mBitmapConfig;
    }

    public int getBackgroundColor() {
        return mBackgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        mBackgroundColor = backgroundColor;
    }

    public int getRadius() {
        return mRadius;
    }

    public int getRadiusDirection() {
        return mRadiusDirection;
    }

    public int getLoadingImageResId() {
        return mLoadingImageResId;
    }

    public Drawable getLoadingImageDrawable() {
        return mLoadingImageDrawable;
    }

    public int getLoadErrorImageResId() {
        return mLoadErrorImageResId;
    }

    public Drawable getLoadErrorImage() {
        return mLoadErrorImage;
    }

    public ScaleTypeConfig getScaleType() {
        return mScaleType;
    }

    public int getEffect() {
        return mEffect;
    }

    public float getThumbnail() {
        return mThumbnail;
    }

    public int getAnimationResId() {
        return mAnimationResId;
    }

    public int getGifLoopCount() {
        return mGifLoopCount;
    }

    public boolean isGif() {
        return mIsGif;
    }

    public int getResizeWidth() {
        return resizeWidth;
    }

    public int getResizeHeight() {
        return resizeHeight;
    }

    public boolean isPreLoad() {
        return mPreLoad;
    }

    public int getBlurRadius() {
        return mBlurRadius;
    }

    public int getBlurSample() {
        return mBlurSample;
    }

    public View getEffectOutputView() {
        return mEffectOutputView;
    }

    public static class Builder {
        /**
         * 是否磁盘缓存
         */
        private boolean mCacheOnDisc = true;
        /**
         * 是否内存缓存
         */
        private boolean mCacheInMemory = true;
        /**
         * bitmap格式设置，RGB8888、RGB656
         * 默认使用RGB_565，减少内存开销
         */
        private Bitmap.Config mBitmapConfig = Bitmap.Config.RGB_565;
        /**
         * 默认背景色，当RGB_565模式的时候，因为没有透明度，透明部分填充这个背景色
         */
        private int mBackgroundColor = Color.WHITE;

        /**
         * 圆角
         */
        private int mRadius = 0;

        /**
         * 圆角方向
         * 默认四个角都设置圆角
         */
        private int mRadiusDirection = RadiusAll;

        /**
         * 加载中图片id
         */
        private @IdRes
        int mLoadingImageResId = -1;

        /**
         * 加载中图片
         */
        private Drawable mLoadingImageDrawable;

        /**
         * 加载失败图片id
         */
        private @IdRes
        int mLoadErrorImageResId = -1;

        /**
         * 加载失败图片
         */
        private Drawable mLoadErrorImage;

        /**
         * Image在ImageView中的显示方式
         */
        private ScaleTypeConfig mScaleType = ScaleTypeConfig.CenterCrop;

        /**
         * Image显示特效
         * 灰阶，高斯模糊等
         */
        private int mEffect = SpecialEffectConfig.None;

        /**
         * 将bitmap输出到这个view的背景上
         */
        private View mEffectOutputView;

        /**
         * 显示缩略图大小
         */
        private float mThumbnail = 0.0f;

        /**
         * 动画资源id
         */
        private @IdRes
        int mAnimationResId = -1;

        /**
         * gif循环次数
         */
        private int mGifLoopCount = 0;

        /**
         * 是否为动画格式
         */
        private boolean mIsGif = false;

        /**
         * resize image 尺寸
         */
        private int resizeWidth = 0;
        private int resizeHeight = 0;

        /**
         * 是否预加载
         */
        private boolean mPreLoad = false;

        /**
         * 高斯模糊半径
         */
        private int mBlurRadius = 25;

        /**
         * 高斯模糊采样率
         */
        private int mBlurSample = 0;

        public Builder cacheOnDisc(boolean val) {
            mCacheOnDisc = val;
            return this;
        }

        public Builder cacheInMemory(boolean val) {
            mCacheInMemory = val;
            return this;
        }

        public Builder bitmapConfig(Bitmap.Config val) {
            mBitmapConfig = val;
            return this;
        }

        public Builder backgroundColor(int color) {
            mBackgroundColor = color;
            return this;
        }

        public Builder radius(int val) {
            mRadius = val;
            return this;
        }

        public Builder radiusDircetion(int direction) {
            mRadiusDirection = direction;
            return this;
        }

        public Builder loadingImageResId(@IdRes int resId) {
            mLoadingImageResId = resId;
            return this;
        }

        public Builder loadingImageDrawable(Drawable drawable) {
            mLoadingImageDrawable = drawable;
            return this;
        }

        public Builder loadErrorImageResId(@IdRes int loadErrorImageResId) {
            mLoadErrorImageResId = loadErrorImageResId;
            return this;
        }

        public Builder loadErrorImageDrawable(Drawable drawable) {
            mLoadErrorImage = drawable;
            return this;
        }

        public Builder scaleType(ScaleTypeConfig val) {
            mScaleType = val;
            return this;
        }

        public Builder effectOption(int effect) {
            mEffect = effect;
            return this;
        }

        public Builder effectOutputView(View view) {
            mEffectOutputView = view;
            return this;
        }

        public Builder thumbnail(float val) {
            mThumbnail = val;
            return this;
        }

        public Builder animationResId(@IdRes int val) {
            mAnimationResId = val;
            return this;
        }

        public Builder gifLoopCount(int val) {
            mGifLoopCount = val;
            return this;
        }

        public Builder isGif(boolean val) {
            mIsGif = val;
            return this;
        }

        public Builder resize(int width, int height) {
            resizeWidth = width;
            resizeHeight = height;
            return this;
        }

        public Builder isPreLoad(boolean val) {
            mPreLoad = val;
            return this;
        }

        public Builder blurRadius(int val) {
            mBlurRadius = val;
            return this;
        }

        public Builder blurSample(int val) {
            mBlurSample = val;
            return this;
        }

        public DisplayConfig build() {
            return new DisplayConfig(this);
        }
    }
}
