/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.mx_image_loader_engine_glide.engine;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.MemoryCategory;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.ImageViewTarget;
import com.bumptech.glide.request.target.Target;
import com.mxchip.config.DisplayConfig;
import com.mxchip.interfaces.IImageLoader;
import com.mxchip.mx_image_loader_engine_glide.factory.RequestOptionFactory;
import com.mxchip.mx_image_loader_engine_glide.transform.BlurTransformation;
import java.io.File;
import java.lang.ref.WeakReference;

public class ImageLoaderGlideEngine
implements IImageLoader {
    private Context mContext;
    private RequestListener mRequestListener;
    private boolean isInit = false;

    private String adapt(String url) {
        if (url == null) {
            return "";
        }
        if (url.startsWith("assets://")) {
            return url.replace("assets://", "file:///android_asset/");
        }
        if (url.startsWith("/")) {
            return "file://" + url;
        }
        return url;
    }

    private DisplayConfig generateDisplayConfig(int radius, int direction) {
        return new DisplayConfig.Builder().radius(radius).radiusDircetion(direction).build();
    }

    public void display(ImageView imageView, String url) {
        this.display(imageView, url, -1);
    }

    public void display(ImageView imageView, String url, int radius) {
        this.display(imageView, url, radius, 4369);
    }

    public void display(ImageView imageView, String url, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(imageView, url, config);
    }

    public void display(ImageView imageView, String url, DisplayConfig config) {
        this.display(Glide.with((Context)this.mContext), url, imageView, config);
    }

    public void display(Activity activity, ImageView imageView, String url) {
        this.display(activity, imageView, url, -1);
    }

    public void display(Activity activity, ImageView imageView, String url, DisplayConfig config) {
        this.display(Glide.with((Activity)activity), url, imageView, config);
    }

    public void display(Activity activity, ImageView imageView, String url, int radius) {
        this.display(activity, imageView, url, radius, 4369);
    }

    public void display(Activity activity, ImageView imageView, String url, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(activity, imageView, url, config);
    }

    public void display(Context context, ImageView imageView, String url) {
        this.display(context, imageView, url, -1);
    }

    public void display(Context context, ImageView imageView, String url, DisplayConfig config) {
        this.display(Glide.with((Context)context), url, imageView, config);
    }

    public void display(Context context, ImageView imageView, String url, int radius) {
        this.display(context, imageView, url, radius, 4369);
    }

    public void display(Context context, ImageView imageView, String url, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(context, imageView, url, config);
    }

    public void display(ImageView imageView, int resId) {
        this.display(imageView, resId, -1);
    }

    public void display(ImageView imageView, int resId, int radius) {
        this.display(imageView, resId, radius, 4369);
    }

    public void display(ImageView imageView, int resId, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(imageView, resId, config);
    }

    public void display(ImageView imageView, int resId, DisplayConfig config) {
        RequestBuilder builder = config.isGif() ? Glide.with((Context)this.mContext).asGif().load(Integer.valueOf(resId)) : Glide.with((Context)this.mContext).load(Integer.valueOf(resId));
        this.display(builder, imageView, config);
    }

    public void display(Activity activity, ImageView imageView, int resId) {
        this.display(activity, imageView, resId, -1);
    }

    public void display(Activity activity, ImageView imageView, int resId, DisplayConfig op) {
        if (activity != null && !activity.isFinishing() && !activity.isDestroyed()) {
            RequestBuilder builder = op != null && op.isGif() ? Glide.with((Activity)activity).asGif().load(Integer.valueOf(resId)) : Glide.with((Activity)activity).load(Integer.valueOf(resId));
            this.display(builder, imageView, op);
        }
    }

    public void display(Activity activity, ImageView imageView, int resId, int radius) {
        this.display(activity, imageView, resId, radius, 4369);
    }

    public void display(Activity activity, ImageView imageView, int resId, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(activity, imageView, resId, config);
    }

    public void display(Context context, ImageView imageView, int resId) {
        this.display(context, imageView, resId, -1);
    }

    public void display(Context context, ImageView imageView, int resId, DisplayConfig op) {
        if (context != null) {
            RequestBuilder builder = op != null && op.isGif() ? Glide.with((Context)context).asGif().load(Integer.valueOf(resId)) : Glide.with((Context)context).load(Integer.valueOf(resId));
            this.display(builder, imageView, op);
        }
    }

    public void display(Context context, ImageView imageView, int resId, int radius) {
        this.display(context, imageView, resId, -1, 4369);
    }

    public void display(Context context, ImageView imageView, int resId, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(context, imageView, resId, config);
    }

    public void display(ImageView imageView, File file) {
        this.display(imageView, file, -1);
    }

    public void display(ImageView imageView, File file, DisplayConfig config) {
        RequestBuilder builder = config.isGif() ? Glide.with((Context)this.mContext).asGif().load(file) : Glide.with((Context)this.mContext).load(file);
        this.display(builder, imageView, config);
    }

    public void display(ImageView imageView, File file, int radius) {
        this.display(imageView, file, radius, 4369);
    }

    public void display(ImageView imageView, File file, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(imageView, file, config);
    }

    public void display(Activity activity, ImageView imageView, File file) {
        this.display(activity, imageView, file, -1);
    }

    public void display(Activity activity, ImageView imageView, File file, DisplayConfig config) {
        if (activity != null && !activity.isFinishing() && !activity.isDestroyed()) {
            RequestBuilder builder = config.isGif() ? Glide.with((Activity)activity).asGif().load(file) : Glide.with((Activity)activity).load(file);
            this.display(builder, imageView, config);
        }
    }

    public void display(Activity activity, ImageView imageView, File file, int radius) {
        this.display(activity, imageView, file, radius, 4369);
    }

    public void display(Activity activity, ImageView imageView, File file, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(activity, imageView, file, config);
    }

    public void display(Context context, ImageView imageView, File file) {
        this.display(context, imageView, file, -1);
    }

    public void display(Context context, ImageView imageView, File file, DisplayConfig config) {
        if (context != null) {
            RequestBuilder builder = config.isGif() ? Glide.with((Context)context).asGif().load(file) : Glide.with((Context)context).load(file);
            this.display(builder, imageView, config);
        }
    }

    public void display(Context context, ImageView imageView, File file, int radius) {
        this.display(context, imageView, file, radius, 4369);
    }

    public void display(Context context, ImageView imageView, File file, int radius, int direction) {
        DisplayConfig config = null;
        if (radius > 0) {
            config = this.generateDisplayConfig(radius, direction);
        }
        this.display(context, imageView, file, config);
    }

    private void display(RequestManager manager, String url, ImageView imageView, DisplayConfig config) {
        RequestBuilder builder = config == null ? manager.asBitmap() : (config.isGif() ? manager.asGif() : manager.asBitmap());
        builder.load(this.adapt(url));
        this.display(builder, imageView, config);
    }

    private void display(RequestBuilder builder, ImageView imageView, DisplayConfig config) {
        WeakReference<ImageView> imageViewWeakReference = new WeakReference<ImageView>(imageView);
        if (imageViewWeakReference.get() == null) {
            return;
        }
        if (config == null) {
            if (imageViewWeakReference.get() != null) {
                builder.into((ImageView)imageViewWeakReference.get());
            }
            return;
        }
        RequestOptionFactory factory = new RequestOptionFactory(this.mContext);
        RequestOptions options = (RequestOptions)factory.toTargetConfig(config);
        if (options != null) {
            builder.apply((BaseRequestOptions)options);
        }
        if (config.getThumbnail() != 0.0f) {
            if (config.getThumbnail() < 0.0f) {
                throw new IllegalArgumentException("thumbnail value cannot a minus value");
            }
            builder.thumbnail(config.getThumbnail());
        }
        if (config.isPreLoad()) {
            builder.preload();
        } else if (config.getEffectOutputView() != null) {
            final DisplayConfig configTmp = config;
            RequestListener requestListener = new RequestListener(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target target, boolean isFirstResource) {
                    return false;
                }

                public boolean onResourceReady(final Object resource, Object model, Target target, DataSource dataSource, boolean isFirstResource) {
                    if (resource instanceof Bitmap && target instanceof ImageViewTarget) {
                        ImageViewTarget ivTarget = (ImageViewTarget)target;
                        final View view = ivTarget.getView();
                        if (configTmp.getEffectOutputView().getMeasuredHeight() == 0) {
                            ViewTreeObserver viewTreeObserver = configTmp.getEffectOutputView().getViewTreeObserver();
                            if (viewTreeObserver.isAlive()) {
                                viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                                    public boolean onPreDraw() {
                                        configTmp.getEffectOutputView().getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                                        new BlurTransformation(ImageLoaderGlideEngine.this.mContext, Glide.get((Context)ImageLoaderGlideEngine.this.mContext).getBitmapPool(), configTmp.getBlurRadius(), configTmp.getBlurSample()).transformToView((Bitmap)resource, view, configTmp.getEffectOutputView());
                                        return false;
                                    }
                                });
                            }
                        } else {
                            new BlurTransformation(ImageLoaderGlideEngine.this.mContext, Glide.get((Context)ImageLoaderGlideEngine.this.mContext).getBitmapPool(), configTmp.getBlurRadius(), configTmp.getBlurSample()).transformToView((Bitmap)resource, view, configTmp.getEffectOutputView());
                        }
                    }
                    return false;
                }
            };
            if (imageViewWeakReference.get() != null) {
                builder.listener(requestListener).into((ImageView)imageViewWeakReference.get());
            }
        } else if (imageViewWeakReference.get() != null) {
            builder.into((ImageView)imageViewWeakReference.get());
        }
    }

    public void startGif(ImageView imageView) {
        if (imageView.getDrawable() != null && imageView.getDrawable() instanceof GifDrawable) {
            ((GifDrawable)imageView.getDrawable()).start();
        }
    }

    public void stopGif(ImageView imageView) {
        if (imageView.getDrawable() != null && imageView.getDrawable() instanceof GifDrawable) {
            ((GifDrawable)imageView.getDrawable()).stop();
        }
    }

    public void recycleGif(ImageView imageView) {
        if (imageView.getDrawable() != null && imageView.getDrawable() instanceof GifDrawable) {
            ((GifDrawable)imageView.getDrawable()).recycle();
        }
    }

    public void cancel(ImageView imageView) {
        Glide.with((Context)this.mContext).clear((View)imageView);
    }

    public void pauseRequest() {
        Glide.with((Context)this.mContext).pauseRequests();
    }

    public void resumeRequest() {
        Glide.with((Context)this.mContext).resumeRequests();
    }

    public void clearMemoryCache() {
        Glide.get((Context)this.mContext).clearMemory();
    }

    public void clearDiskCache() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Glide.get((Context)ImageLoaderGlideEngine.this.mContext).clearDiskCache();
            }
        });
    }

    public void onTrimMemory(int level) {
        Glide.get((Context)this.mContext).onTrimMemory(level);
    }

    public void onLowMemory() {
        Glide.get((Context)this.mContext).onLowMemory();
    }

    public void init(Context context) {
        this.mContext = context;
        Glide.get((Context)context.getApplicationContext()).setMemoryCategory(MemoryCategory.NORMAL);
        this.isInit = true;
    }

    public void release() {
        if (this.isInit) {
            if (Looper.getMainLooper() == Looper.myLooper()) {
                this.clearMemoryCache();
                Glide.with((Context)this.mContext).onDestroy();
                this.isInit = false;
            } else {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ImageLoaderGlideEngine.this.clearMemoryCache();
                        Glide.with((Context)ImageLoaderGlideEngine.this.mContext).onDestroy();
                        ImageLoaderGlideEngine.this.isInit = false;
                    }
                });
            }
        }
    }
}

