/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.mx_image_loader_engine_glide.transform;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.security.MessageDigest;

public class RoundedCornersTransformation
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;
    private int mRadius;
    private int mDiameter;
    private int mMargin;
    private int mBgColor;
    private CornerType mCornerType;
    private Bitmap.Config mBitmapConfig;

    public RoundedCornersTransformation(Context context, int radius, int margin, int bgColor, Bitmap.Config bitmapConfig) {
        this(context, radius, margin, bgColor, CornerType.ALL, bitmapConfig);
    }

    public RoundedCornersTransformation(BitmapPool pool, int radius, int margin, int bgColor, Bitmap.Config bitmapConfig) {
        this(pool, radius, margin, bgColor, CornerType.ALL, bitmapConfig);
    }

    public RoundedCornersTransformation(Context context, int radius, int margin, int bgColor, CornerType cornerType, Bitmap.Config bitmapConfig) {
        this(Glide.get((Context)context).getBitmapPool(), radius, margin, bgColor, cornerType, bitmapConfig);
    }

    public RoundedCornersTransformation(BitmapPool pool, int radius, int margin, int bgColor, CornerType cornerType, Bitmap.Config bitmapConfig) {
        this.mBitmapPool = pool;
        this.mRadius = radius;
        this.mDiameter = this.mRadius * 3;
        this.mMargin = margin;
        this.mBgColor = bgColor;
        this.mCornerType = cornerType;
        this.mBitmapConfig = bitmapConfig;
    }

    @NonNull
    public Resource<Bitmap> transform(@NonNull Context context, @NonNull Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap bitmap;
        Bitmap source = (Bitmap)resource.get();
        int width = source.getWidth();
        int height = source.getHeight();
        Bitmap.Config config = this.mBitmapConfig;
        if (config == null) {
            Bitmap.Config config2 = config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888;
        }
        if ((bitmap = this.mBitmapPool.get(width, height, config)) == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        Canvas canvas = new Canvas(bitmap);
        if (config == Bitmap.Config.RGB_565) {
            canvas.drawColor(this.mBgColor);
        }
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        this.drawRoundRect(canvas, paint, width, height);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    private void drawRoundRect(Canvas canvas, Paint paint, int width, int height) {
        float right = width - this.mMargin;
        float bottom = height - this.mMargin;
        switch (this.mCornerType) {
            case ALL: {
                canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
                break;
            }
            case TOP_LEFT: {
                this.drawTopLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case TOP_RIGHT: {
                this.drawTopRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case BOTTOM_LEFT: {
                this.drawBottomLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case BOTTOM_RIGHT: {
                this.drawBottomRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case TOP: {
                this.drawTopRoundRect(canvas, paint, right, bottom);
                break;
            }
            case BOTTOM: {
                this.drawBottomRoundRect(canvas, paint, right, bottom);
                break;
            }
            case LEFT: {
                this.drawLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case RIGHT: {
                this.drawRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case OTHER_TOP_LEFT: {
                this.drawOtherTopLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case OTHER_TOP_RIGHT: {
                this.drawOtherTopRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case OTHER_BOTTOM_LEFT: {
                this.drawOtherBottomLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case OTHER_BOTTOM_RIGHT: {
                this.drawOtherBottomRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case DIAGONAL_FROM_TOP_LEFT: {
                this.drawDiagonalFromTopLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case DIAGONAL_FROM_TOP_RIGHT: {
                this.drawDiagonalFromTopRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            default: {
                canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
            }
        }
    }

    private void drawTopLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)(this.mMargin + this.mRadius), (float)(this.mMargin + this.mRadius), bottom), paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, right, bottom), paint);
    }

    private void drawTopRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(right - (float)this.mDiameter, (float)this.mMargin, right, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, right - (float)this.mRadius, bottom), paint);
        canvas.drawRect(new RectF(right - (float)this.mRadius, (float)(this.mMargin + this.mRadius), right, bottom), paint);
    }

    private void drawBottomLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, bottom - (float)this.mDiameter, (float)(this.mMargin + this.mDiameter), bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), bottom - (float)this.mRadius), paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, right, bottom), paint);
    }

    private void drawBottomRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(right - (float)this.mDiameter, bottom - (float)this.mDiameter, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, right - (float)this.mRadius, bottom), paint);
        canvas.drawRect(new RectF(right - (float)this.mRadius, (float)this.mMargin, right, bottom - (float)this.mRadius), paint);
    }

    private void drawTopRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, right, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)(this.mMargin + this.mRadius), right, bottom), paint);
    }

    private void drawBottomRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, bottom - (float)this.mDiameter, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, right, bottom - (float)this.mRadius), paint);
    }

    private void drawLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, right, bottom), paint);
    }

    private void drawRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(right - (float)this.mDiameter, (float)this.mMargin, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, right - (float)this.mRadius, bottom), paint);
    }

    private void drawOtherTopLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, bottom - (float)this.mDiameter, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF(right - (float)this.mDiameter, (float)this.mMargin, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, right - (float)this.mRadius, bottom - (float)this.mRadius), paint);
    }

    private void drawOtherTopRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF((float)this.mMargin, bottom - (float)this.mDiameter, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, right, bottom - (float)this.mRadius), paint);
    }

    private void drawOtherBottomLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, right, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF(right - (float)this.mDiameter, (float)this.mMargin, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)(this.mMargin + this.mRadius), right - (float)this.mRadius, bottom), paint);
    }

    private void drawOtherBottomRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, right, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)(this.mMargin + this.mRadius), right, bottom), paint);
    }

    private void drawDiagonalFromTopLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF(right - (float)this.mDiameter, bottom - (float)this.mDiameter, right, bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)(this.mMargin + this.mRadius), right - (float)this.mRadius, bottom), paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, right, bottom - (float)this.mRadius), paint);
    }

    private void drawDiagonalFromTopRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(right - (float)this.mDiameter, (float)this.mMargin, right, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF((float)this.mMargin, bottom - (float)this.mDiameter, (float)(this.mMargin + this.mDiameter), bottom), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, right - (float)this.mRadius, bottom - (float)this.mRadius), paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)(this.mMargin + this.mRadius), right, bottom), paint);
    }

    private String getId() {
        return "RoundedTransformation(radius=" + this.mRadius + ", margin=" + this.mMargin + ", diameter=" + this.mDiameter + ", cornerType=" + this.mCornerType.name() + ")";
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj.hashCode() == this.hashCode();
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        messageDigest.update(this.getId().getBytes());
    }

    public static enum CornerType {
        ALL,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        OTHER_TOP_LEFT,
        OTHER_TOP_RIGHT,
        OTHER_BOTTOM_LEFT,
        OTHER_BOTTOM_RIGHT,
        DIAGONAL_FROM_TOP_LEFT,
        DIAGONAL_FROM_TOP_RIGHT;

    }
}

