/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jersey.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.munit.Coverage;
import org.mule.munit.ResolvedPom;
import org.mule.munit.coverage.CoverageLimitsChecker;
import org.mule.munit.mojo.ApplicationResultPrinterFactory;
import org.mule.munit.mojo.exceptions.MojoExecutionExceptionFactory;
import org.mule.munit.plugin.maven.AbstractMunitMojo;
import org.mule.munit.plugin.maven.RuntimeProducts;
import org.mule.munit.plugin.maven.TargetRuntime;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.project.ApplicationStructureGenerator;
import org.mule.munit.remote.api.project.MuleApplicationStructureGenerator;
import org.mule.munit.util.ApplicationRunConfigurationFactory;
import org.mule.tools.api.packager.Pom;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class MUnitMojo
extends AbstractMunitMojo {
    @Parameter(property="munit.coverage")
    protected Coverage coverage;
    @Parameter(defaultValue="${munit.randomFailMessages}")
    private boolean randomFailMessages = false;
    @Parameter(defaultValue="${plugin.version}")
    protected String pluginVersion;
    @Parameter(property="munit.coverageReportData", defaultValue="${project.build.directory}/munit-reports/coverage-report.data")
    protected File coverageReportDataFile;
    @Parameter(property="munit.coverageConfigData", defaultValue="${project.build.directory}/munit-reports/coverage-config.data")
    protected File coverageConfigDataFile;
    protected MojoExecutionExceptionFactory exceptionFactory;
    protected CoverageLimitsChecker coverageLimitsChecker;

    protected void init() throws MojoExecutionException {
        super.init();
        this.exceptionFactory = new MojoExecutionExceptionFactory(this.randomFailMessages);
        this.coverageLimitsChecker = new CoverageLimitsChecker(this.coverage, this.muleApplicationModelLoader.getRuntimeProduct(), this.getLog());
    }

    protected void handleRunResult(TargetRuntime targetRuntime, RunResult runResult) {
        super.handleRunResult(targetRuntime, runResult);
        runResult.getApplicationCoverageReport().ifPresent(this.coverageLimitsChecker::setCoverageReport);
        this.saveRunDataToFile(runResult);
    }

    protected void failBuildIfNecessary(Map<TargetRuntime, RunResult> runResults) throws MojoExecutionException {
        try {
            super.failBuildIfNecessary(runResults);
        }
        catch (MojoExecutionException cause) {
            throw this.exceptionFactory.buildException("Build Failed", cause);
        }
        if (this.coverage != null && this.coverage.isRunCoverage().booleanValue() && !RuntimeProducts.EE.value().equals(this.muleApplicationModelLoader.getRuntimeProduct())) {
            this.getLog().warn((CharSequence)"Coverage is a EE only feature and you've selected to run over CE");
        }
        if (this.coverageLimitsChecker.failBuild().booleanValue()) {
            throw new MojoExecutionException("Build Failed", (Exception)new MojoFailureException("Coverage limits were not reached"));
        }
    }

    protected Map<TargetRuntime, RunConfiguration> getRunConfigurations() throws MojoExecutionException {
        TargetRuntime targetRuntime = new TargetRuntime(this.muleApplicationModelLoader.getRuntimeVersion(), this.muleApplicationModelLoader.getRuntimeProduct());
        return ImmutableMap.of((Object)targetRuntime, (Object)new ApplicationRunConfigurationFactory(this.getLog(), this.munitTest, this.munitTags, this.skipAfterFailure, targetRuntime, this.workingDirectoryGenerator, this.munitTestsDirectory, this.coverage, this.pluginVersion, this.project, this.session).create());
    }

    protected ResultPrinterFactory getResultPrinterFactory() {
        return new ApplicationResultPrinterFactory(this.getLog()).withCoverageSummaryReport(this.coverage, this.muleApplicationModelLoader.getRuntimeProduct()).withSurefireReports(this.enableSurefireReports, this.surefireReportsFolder, this.effectiveSystemProperties).withTestOutputReports(Boolean.valueOf(this.redirectTestOutputToFile), this.testOutputDirectory);
    }

    protected ApplicationStructureGenerator getApplicationStructureGenerator() {
        return new MuleApplicationStructureGenerator(this.project.getBasedir().toPath(), Paths.get(this.project.getBuild().getDirectory(), new String[0]), (Pom)new ResolvedPom(this.project), this.createDependencies());
    }

    protected File getMuleApplicationJsonPath() {
        Path projectBuildDirectoryPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path muleApplicationJsonPath = projectBuildDirectoryPath.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("mule-artifact.json");
        return muleApplicationJsonPath.toFile();
    }

    private void saveRunDataToFile(RunResult runResult) {
        this.saveAsJsonDataToFile(this.coverage == null ? new Coverage() : this.coverage, this.coverageConfigDataFile);
        runResult.getApplicationCoverageReport().ifPresent(this::saveCoverageReportDataToFile);
    }

    private void saveCoverageReportDataToFile(ApplicationCoverageReport applicationCoverageReport) {
        this.saveAsJsonDataToFile(applicationCoverageReport, this.coverageReportDataFile);
    }

    private List<BundleDependency> createDependencies() {
        Map artifacts = this.project.getArtifacts().parallelStream().collect(Collectors.toMap(this::toDescriptor, Function.identity(), (oldValue, newValue) -> {
            if (oldValue.getType().equals(newValue.getType())) {
                return oldValue.hasClassifier() ? oldValue : newValue;
            }
            throw new IllegalArgumentException("Duplicate keys with different values: " + oldValue + " != " + newValue);
        }));
        Map<BundleDescriptor, BundleScope> scopes = artifacts.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toScope((Artifact)entry.getValue())));
        Map<BundleDescriptor, URI> uris = artifacts.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toUri((Artifact)entry.getValue())));
        HashSet direct = new HashSet();
        Map transitive = artifacts.keySet().parallelStream().collect(Collectors.toMap(Function.identity(), unused -> new HashSet()));
        for (BundleDescriptor descriptor2 : artifacts.keySet()) {
            BundleDescriptor predecessor = this.toDescriptor(((Artifact)artifacts.get(descriptor2)).getDependencyTrail());
            ((Set)transitive.getOrDefault(predecessor, direct)).add(descriptor2);
        }
        return direct.parallelStream().map(descriptor -> this.toDependency((BundleDescriptor)descriptor, scopes, uris, transitive)).collect(Collectors.toList());
    }

    private BundleDescriptor toDescriptor(Artifact artifact) {
        return new BundleDescriptor.Builder().setGroupId(artifact.getGroupId()).setArtifactId(artifact.getArtifactId()).setVersion(artifact.getVersion()).setType(artifact.getType()).setClassifier(artifact.getClassifier()).build();
    }

    private BundleDescriptor toDescriptor(List<String> trail) {
        return this.toDescriptor(trail.get(trail.size() - 2));
    }

    private BundleDescriptor toDescriptor(String id) {
        String[] parts = id.split(":");
        return new BundleDescriptor.Builder().setGroupId(parts[0]).setArtifactId(parts[1]).setType(parts[2]).setVersion(parts[3]).build();
    }

    private BundleScope toScope(Artifact artifact) {
        return Optional.ofNullable(artifact.getScope()).map(scope -> BundleScope.valueOf((String)scope.toUpperCase())).orElse(BundleScope.COMPILE);
    }

    private URI toUri(Artifact artifact) {
        return artifact.getFile().toURI();
    }

    private BundleDependency toDependency(BundleDescriptor descriptor, Map<BundleDescriptor, BundleScope> scopes, Map<BundleDescriptor, URI> uris, Map<BundleDescriptor, Set<BundleDescriptor>> transitive) {
        BundleDependency.Builder builder = new BundleDependency.Builder();
        builder.setDescriptor(descriptor);
        builder.setScope(scopes.get(descriptor));
        builder.setBundleUri(uris.get(descriptor));
        for (BundleDescriptor transitiveDescriptor : transitive.get(descriptor)) {
            builder.addTransitiveDependency(this.toDependency(transitiveDescriptor, scopes, uris, transitive));
        }
        return builder.build();
    }
}

