/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class ClasspathManager {
    private Log log;
    private Class runnerClass;
    private List<String> classpathElements;

    public ClasspathManager(List<String> classpathElements, Class runnerClass, Log log) {
        this.classpathElements = classpathElements;
        this.runnerClass = runnerClass;
        this.log = log;
    }

    public List<String> getEffectiveClasspath() {
        ArrayList<String> effectiveClasspath = new ArrayList<String>();
        this.addRunnerClassDependency(effectiveClasspath);
        this.log.debug((CharSequence)"Classpath: ");
        effectiveClasspath.forEach(classpathEntry -> this.log.debug((CharSequence)classpathEntry));
        return effectiveClasspath;
    }

    private void addRunnerClassDependency(List<String> effectiveClasspath) {
        if (this.runnerClass != null) {
            String runnerClassDependency = this.runnerClass.getProtectionDomain().getCodeSource().getLocation().getPath();
            effectiveClasspath.add(runnerClassDependency);
            this.log.debug((CharSequence)String.format("Runner dependency added: %s", runnerClassDependency));
        } else {
            this.log.info((CharSequence)"The runner class provided is null");
        }
    }
}

