/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathManager {
    private static final String CLASSPATH_EXCLUDE_SEPARATOR = ":";
    private List<String> zipDependencies;
    private List<String> additionalClasspathElements;
    private List<String> classpathDependencyExcludes;
    private List<String> classpathElements;
    private Set<Artifact> artifacts;
    private Class runnerClass;
    private Log log;

    public ClasspathManager(List<String> classpathElements, List<String> zipDependencies, List<String> additionalClasspathElements, List<String> classpathDependencyExcludes, Set artifacts, Class runnerClass, Log log) {
        this.classpathElements = classpathElements;
        this.zipDependencies = zipDependencies;
        this.additionalClasspathElements = additionalClasspathElements;
        this.classpathDependencyExcludes = classpathDependencyExcludes;
        this.artifacts = artifacts;
        this.runnerClass = runnerClass;
        this.log = log;
    }

    public List<String> getEffectiveClasspath() {
        ArrayList<String> effectiveClasspath = new ArrayList<String>();
        effectiveClasspath.addAll(this.classpathElements);
        this.addRunnerClassDependency(effectiveClasspath);
        this.addZipDependencies(effectiveClasspath);
        this.excludeDependenciesFromClasspath(effectiveClasspath);
        this.addAdditionalClasspathElements(effectiveClasspath);
        this.log.debug((CharSequence)"Classpath: ");
        for (String classpathEntry : effectiveClasspath) {
            this.log.debug((CharSequence)classpathEntry);
        }
        return effectiveClasspath;
    }

    private void addRunnerClassDependency(List<String> effectiveClasspath) {
        if (this.runnerClass != null) {
            String runnerClassDependency = this.runnerClass.getProtectionDomain().getCodeSource().getLocation().getPath();
            effectiveClasspath.add(runnerClassDependency);
            this.log.debug((CharSequence)String.format("Runner dependency added: %s", runnerClassDependency));
        } else {
            this.log.info((CharSequence)"The runner class provided is null");
        }
    }

    private void addZipDependencies(List<String> effectiveClasspath) {
        if (this.zipDependencies != null) {
            effectiveClasspath.addAll(this.zipDependencies);
        }
    }

    private void excludeDependenciesFromClasspath(List<String> effectiveClasspath) {
        if (this.classpathDependencyExcludes != null) {
            ArrayList<String> classpathEntriesToRemove = new ArrayList<String>();
            for (Artifact artifact : this.artifacts) {
                String identifier = artifact.getGroupId() + CLASSPATH_EXCLUDE_SEPARATOR + artifact.getArtifactId();
                if (!this.classpathDependencyExcludes.contains(identifier)) continue;
                String entryPath = artifact.getFile().getAbsolutePath();
                classpathEntriesToRemove.add(entryPath);
                this.log.debug((CharSequence)String.format("Entry %s will be removed from classpath", entryPath));
            }
            effectiveClasspath.removeAll(classpathEntriesToRemove);
        }
    }

    private void addAdditionalClasspathElements(List<String> effectiveClasspath) {
        if (this.additionalClasspathElements != null) {
            for (String classpathEntry : this.additionalClasspathElements) {
                if (this.validateClasspathEntry(classpathEntry)) {
                    effectiveClasspath.add(classpathEntry);
                    continue;
                }
                this.log.warn((CharSequence)String.format("Unable to add entry %s to classpath because it does not exist", classpathEntry));
            }
        }
    }

    protected boolean validateClasspathEntry(String classpathEntry) {
        return new File(classpathEntry).exists();
    }
}

