/*
 * Decompiled with CFR 0.152.
 */
package org.mule.coverage;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.mule.api.MuleContext;
import org.mule.munit.plugins.coverage.PathBuilder;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.spring.config.model.MockingConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPathBuilder {
    private Log log;
    private String resources;
    private Set<String> flowPaths;
    private Set<String> subFlowPaths;
    private Set<String> batchPaths;

    public ApplicationPathBuilder(String resources) {
        this.resources = resources;
    }

    public String getResources() {
        return this.resources;
    }

    public Set<String> getFlowPaths() {
        if (null == this.flowPaths) {
            this.buildApplicationPaths();
        }
        return this.flowPaths;
    }

    public Set<String> getSubFlowPaths() {
        if (null == this.subFlowPaths) {
            this.buildApplicationPaths();
        }
        return this.subFlowPaths;
    }

    public Set<String> getBatchPaths() {
        if (null == this.batchPaths) {
            this.buildApplicationPaths();
        }
        return this.batchPaths;
    }

    private void buildApplicationPaths() {
        this.debug("Counting application flow paths: " + new Date().toString());
        String originalCoveragePort = System.clearProperty("cobertura.port");
        MuleContextManager muleContextManager = null;
        MuleContext muleContext = null;
        try {
            if (muleContext == null || muleContext.isDisposed()) {
                muleContextManager = new MuleContextManager(this.createConfiguration());
                muleContext = muleContextManager.createMule(this.resources);
                muleContext = muleContextManager.startMule(muleContext);
                PathBuilder pathBuilder = new PathBuilder(muleContext);
                this.flowPaths = new HashSet(pathBuilder.buildFlowPathsMap().values());
                this.subFlowPaths = new HashSet(pathBuilder.buildSubFlowPathsMap().values());
                this.batchPaths = new HashSet(pathBuilder.buildBatchPathsMap().values());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            muleContextManager.killMule(muleContext);
            if (null != originalCoveragePort) {
                System.setProperty("cobertura.port", originalCoveragePort);
            }
            this.debug("Application flow paths count done: " + new Date().toString());
        }
    }

    private MockingConfiguration createConfiguration() {
        return new MockingConfiguration(true, new ArrayList(), true, null);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private void info(String msg) {
        if (this.log != null) {
            this.log.info((CharSequence)msg);
        }
    }

    private void warn(String msg) {
        if (this.log != null) {
            this.log.warn((CharSequence)msg);
        }
    }

    private void debug(String msg) {
        if (this.log != null) {
            this.log.debug((CharSequence)msg);
        }
    }

    private void error(String msg) {
        if (this.log != null) {
            this.log.error((CharSequence)msg);
        }
    }
}

