/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;

public class LocationGrouper {
    private Set<CoverageComponentLocation> locations;

    public LocationGrouper(Set<CoverageComponentLocation> locations) {
        Preconditions.checkNotNull(locations, (Object)"The covered location must not be null");
        this.locations = locations;
    }

    public Map<LocationPart, Set<CoverageComponentLocation>> groupByFlow() {
        HashMap<LocationPart, Set<CoverageComponentLocation>> locationsPerFlow = new HashMap<LocationPart, Set<CoverageComponentLocation>>();
        for (CoverageComponentLocation location : this.locations) {
            LocationPart partIdentifier = location.getParts().get(0);
            if (!locationsPerFlow.containsKey(partIdentifier)) {
                locationsPerFlow.put(partIdentifier, new HashSet());
            }
            ((Set)locationsPerFlow.get(partIdentifier)).add(location);
        }
        return locationsPerFlow;
    }

    public Map<String, Set<CoverageComponentLocation>> groupByFile() {
        HashMap<String, Set<CoverageComponentLocation>> locationsPerFile = new HashMap<String, Set<CoverageComponentLocation>>();
        for (CoverageComponentLocation location : this.locations) {
            String fileName = location.getFileName().get();
            if (!locationsPerFile.containsKey(fileName)) {
                locationsPerFile.put(fileName, new HashSet());
            }
            ((Set)locationsPerFile.get(fileName)).add(location);
        }
        return locationsPerFile;
    }
}

