/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.notifiers;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.TestStatus;

public class StreamNotifier
implements RunEventListener {
    private static final String SUITE_TOKEN = "=";
    private static final String TEST_TOKEN = "+";
    private static final Integer LINE_LENGTH = 80;
    private PrintStream out;
    private int tests = 0;
    private int failures = 0;
    private int errors = 0;
    private int skipped = 0;

    public StreamNotifier(PrintStream out) {
        this.out = out;
    }

    public void notifyTestStart(String name, String description, boolean isIgnored, String fileName) {
        String descriptionMessage = StringUtils.isBlank((CharSequence)description) ? "" : " - " + description;
        String title = StringUtils.repeat((String)TEST_TOKEN, (int)LINE_LENGTH);
        String message = isIgnored ? "Ignoring test: " + name + descriptionMessage : "Running test: " + name + descriptionMessage;
        this.out.println(title);
        this.out.println(this.generateMessage("+ ", TEST_TOKEN, message));
        this.out.println(title);
        this.out.flush();
    }

    public void notifySuiteStart(String suite, String parameterization, int numberOfTests) {
        String suiteMessage = "Running suite: " + suite;
        if (StringUtils.isNotBlank((CharSequence)parameterization)) {
            suiteMessage = suiteMessage + "[" + parameterization + "]";
        }
        String title = StringUtils.repeat((String)SUITE_TOKEN, (int)LINE_LENGTH);
        this.out.println(title);
        this.out.println(this.generateMessage(StringUtils.repeat((String)SUITE_TOKEN, (int)3) + " ", StringUtils.repeat((String)SUITE_TOKEN, (int)3), suiteMessage));
        this.out.println(title);
        this.out.flush();
    }

    public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime, String fileName) {
        ++this.tests;
        switch (status) {
            case SUCCESS: {
                break;
            }
            case ERROR: {
                ++this.errors;
                break;
            }
            case FAILURE: {
                ++this.failures;
                break;
            }
            case IGNORED: {
                ++this.skipped;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)stackTrace)) {
            this.out.println(StringUtils.repeat((String)TEST_TOKEN, (int)LINE_LENGTH));
            this.out.println(stackTrace);
            this.out.println(StringUtils.repeat((String)TEST_TOKEN, (int)LINE_LENGTH));
        }
        this.out.flush();
    }

    public void notifySuiteEnd(String suite, String parameterization, long elapsedTime) {
        String title = "Tests run: %d - Failed: %d - Errors: %d - Skipped: %d - Time elapsed: %.2f sec";
        String titleFrame = StringUtils.repeat((String)SUITE_TOKEN, (int)LINE_LENGTH);
        this.out.println(titleFrame);
        this.out.println(this.generateMessage("= ", SUITE_TOKEN, String.format(title, this.tests, this.failures, this.errors, this.skipped, (double)elapsedTime / 1000.0)));
        this.out.println(titleFrame);
        this.out.flush();
    }

    private String generateMessage(String prefix, String suffix, String message) {
        return this.splitInLines(message, LINE_LENGTH - (prefix.length() + suffix.length())).stream().map(line -> prefix + line + StringUtils.repeat((String)" ", (int)(LINE_LENGTH - (line.length() + prefix.length() + suffix.length()))) + suffix).collect(Collectors.joining(System.lineSeparator()));
    }

    private List<String> splitInLines(String line, int length) {
        ArrayList<String> list = new ArrayList<String>((line.length() + length - 1) / length);
        for (int start = 0; start < line.length(); start += length) {
            list.add(line.substring(start, Math.min(line.length(), start + length)));
        }
        return list;
    }
}

