/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.flow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.exception.MunitFail;
import org.mule.munit.common.util.MunitExpressionWrapper;
import org.mule.munit.runner.component.TestComponent;
import org.mule.munit.runner.model.TestExecutionException;
import org.mule.munit.runner.processors.EnableFlowSources;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.privileged.processor.CompositeProcessorChainRouter;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFlow
extends CompositeProcessorChainRouter
implements TestComponent {
    public static final String MUNIT_TEST_TIMEOUT_PROPERTY = "munit.test.timeout";
    protected static final transient Logger logger = LoggerFactory.getLogger(TestFlow.class);
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final String TAG_SEPARATOR = ",";
    private static Method getSuppressedErrorsMethod;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    @Inject
    protected Optional<MunitModule> munitModule;
    @Inject
    private SchedulerService schedulerService;
    private String description;
    private String ignore;
    private String expectedErrorType;
    private String expectedException;
    private String expectedErrorDescription;
    private String tags;
    private List<EnableFlowSources.FlowRef> enableFlowSources;
    private List<MessageSource> flowSources = Collections.emptyList();
    private Integer timeOut;
    private Scheduler scheduler;
    private Map<String, ProcessingStrategy> childProcessingStrategies = new HashMap<String, ProcessingStrategy>();
    private final Pattern booleanPattern = Pattern.compile("true|false");
    private final AtomicBoolean logSuppressedMatch = new AtomicBoolean(true);

    @Override
    public boolean isIgnored() {
        this.validateIgnore(this.ignore);
        return this.booleanPattern.matcher(this.ignore).matches() ? Boolean.valueOf(this.ignore).booleanValue() : ((Boolean)this.getExpressionWrapper().evaluate((Object)this.ignore).getValue()).booleanValue();
    }

    public void setIgnore(String ignore) {
        this.validateIgnore(ignore);
        this.ignore = ignore;
    }

    public String getExpectedErrorType() {
        return this.expectedErrorType;
    }

    public void setExpectedErrorType(String expectedErrorType) {
        this.expectedErrorType = expectedErrorType;
    }

    public String getExpectedException() {
        return this.expectedException;
    }

    public void setExpectedException(String expectedException) {
        this.expectedException = expectedException;
    }

    public String getExpectedErrorDescription() {
        return this.expectedErrorDescription;
    }

    public void setExpectedErrorDescription(String expectedErrorDescription) {
        this.expectedErrorDescription = expectedErrorDescription;
    }

    public void setTimeOut(Integer timeout) {
        this.timeOut = timeout;
    }

    public Integer getTimeOut() {
        return this.timeOut;
    }

    @Override
    public Set<String> getTags() {
        if (StringUtils.isBlank((CharSequence)this.tags)) {
            return Collections.emptySet();
        }
        Set<String> tagSet = Stream.of(this.tags.split(TAG_SEPARATOR)).collect(Collectors.toSet());
        if (tagSet.stream().anyMatch(tag -> tag.trim().equalsIgnoreCase("NO_TAG"))) {
            throw new IllegalArgumentException("The tag 'NO_TAG' is invalid since it's a keyword.");
        }
        return tagSet;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<EnableFlowSources.FlowRef> getEnableFlowSources() {
        return this.enableFlowSources;
    }

    public void setEnableFlowSources(List<EnableFlowSources.FlowRef> enableFlowSources) {
        this.enableFlowSources = enableFlowSources;
        this.flowSources = this.getFlowSources(enableFlowSources);
        if (this.munitModule.isPresent() && !this.isIgnored()) {
            this.munitModule.get().addEnableFlowSources(enableFlowSources);
        }
    }

    @Override
    public String getName() {
        return this.getLocation().getRootContainerName();
    }

    @Override
    public Event run(Event event) throws Throwable {
        try {
            Event resultingEvent = this.doExecute(event);
            if (this.isExpectingFailure()) {
                StringBuilder builder = new StringBuilder();
                builder.append("The test: ").append(this.getName()).append(" was expecting a failure");
                if (this.expectedErrorType != null) {
                    builder.append(" - Error ID: ").append(this.expectedErrorType);
                }
                if (this.expectedException != null) {
                    builder.append(" - Exception: ").append(this.expectedException);
                }
                if (this.expectedErrorDescription != null) {
                    builder.append(" - Error Description: ").append(this.expectedErrorDescription);
                }
                builder.append(" but it didn't fail");
                MunitFail.fail((String)builder.toString());
            }
            return resultingEvent;
        }
        catch (ExecutionException executionException) {
            if (!(executionException.getCause() instanceof ComponentExecutionException)) {
                throw executionException;
            }
            ComponentExecutionException componentExecutionException = (ComponentExecutionException)executionException.getCause();
            Event exceptionEvent = componentExecutionException.getEvent();
            Error error = (Error)exceptionEvent.getError().orElseThrow(() -> new MunitError("Test " + this.getName() + " failed but no error is present in event"));
            if (this.isExpectingFailure()) {
                Optional<MunitFail> comparisonFailure = this.validateExpected(error, exceptionEvent);
                if (comparisonFailure.isPresent()) {
                    throw new AssertionError(comparisonFailure.get().getMessage(), error.getCause());
                }
                return exceptionEvent;
            }
            Throwable rootCause = Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)error.getCause())).orElse(error.getCause());
            throw rootCause instanceof AssertionError ? rootCause : new TestExecutionException(executionException, error, this.getName());
        }
    }

    @Override
    public void setUp() {
        this.startFlowSources();
    }

    @Override
    public void tearDown() {
        this.stopFlowSources();
    }

    public void startFlowSources() {
        try {
            LifecycleUtils.startIfNeeded(this.flowSources);
        }
        catch (MuleException e) {
            throw new MunitError("An error occurred while starting flow sources", (Throwable)e);
        }
    }

    public void stopFlowSources() {
        try {
            LifecycleUtils.stopIfNeeded(this.flowSources);
        }
        catch (MuleException e) {
            throw new MunitError("An error occurred while stopping flow sources", (Throwable)e);
        }
    }

    protected Event doExecute(Event event) throws InterruptedException, ExecutionException {
        Either submissionResult;
        try {
            submissionResult = (Either)this.scheduler.submit((Callable)new ExceptionAwareCallable(event)).get(this.getTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new MunitError(String.format("The test '%s' timeout after %s milliseconds", this.getName(), this.getTimeout()));
        }
        if (submissionResult.isRight()) {
            Throwable throwable = (Throwable)submissionResult.getRight();
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            if (throwable instanceof ExecutionException) {
                throw (ExecutionException)throwable;
            }
            throw new MunitError("Unknown error occurred executing the test", throwable);
        }
        return (Event)submissionResult.getLeft();
    }

    protected boolean isExpectingFailure() {
        return StringUtils.isNotBlank((CharSequence)this.expectedErrorType) || StringUtils.isNotBlank((CharSequence)this.expectedException) || StringUtils.isNotBlank((CharSequence)this.expectedErrorDescription);
    }

    protected Optional<MunitFail> validateExpected(Error error, Event exceptionEvent) throws MunitError {
        if (!this.isExpectingFailure()) {
            return Optional.empty();
        }
        Throwable cause = error.getCause();
        MunitFail failure = null;
        if (StringUtils.isNotBlank((CharSequence)this.expectedErrorType) && !this.isErrorIdExpected(exceptionEvent)) {
            String actualErrorType = error.getErrorType().toString();
            failure = new MunitFail("The error ID thrown does not match the expected one. ", this.expectedErrorType, actualErrorType);
        } else if (StringUtils.isNotBlank((CharSequence)this.expectedException) && !this.isExceptionExpected(error, exceptionEvent)) {
            String actualException = cause.getClass().getName();
            failure = new MunitFail("The exception thrown does not match the expected one. ", this.expectedException, actualException);
        } else if (StringUtils.isNotBlank((CharSequence)this.expectedErrorDescription) && !this.isErrorDescriptionExpected(error)) {
            String actualErrorDescription = error.getDescription();
            failure = new MunitFail("The error description thrown does not match the expected one.", this.expectedErrorDescription, actualErrorDescription);
        }
        return Optional.ofNullable(failure);
    }

    protected boolean isErrorIdExpected(Event exceptionEvent) throws MunitError {
        Object errorId = this.getExpressionWrapper().evaluateIfExpression(exceptionEvent, (Object)this.expectedErrorType).getValue();
        if (errorId instanceof String) {
            try {
                ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)((String)errorId).toUpperCase());
                Optional errorType = this.errorTypeRepository.getErrorType(errorTypeComponentIdentifier);
                SingleErrorTypeMatcher errorTypeMatcher = new SingleErrorTypeMatcher((ErrorType)errorType.orElseThrow(() -> new MunitError("The expected error type " + errorId + " was not found")));
                Error eventError = (Error)exceptionEvent.getError().orElseThrow(() -> new MunitError("The event has no error"));
                return this.isMatch(errorTypeMatcher, eventError);
            }
            catch (IllegalStateException e) {
                throw new MunitError("Expect error id " + errorId + " was never registered it can not be thrown", (Throwable)e);
            }
        }
        throw new MunitError("Expect error id expression error. The expression should return a valid string");
    }

    protected boolean isExceptionExpected(Error error, Event exceptionEvent) throws MunitError {
        if (this.getExpressionWrapper().isExpressionValid((Object)this.expectedException)) {
            return this.evaluateExpectException(exceptionEvent);
        }
        return this.exceptionMatches(error);
    }

    protected boolean isErrorDescriptionExpected(Error error) throws MunitError {
        return error.getDescription().contains(this.expectedErrorDescription);
    }

    protected Boolean evaluateExpectException(Event event) throws MunitError {
        try {
            Object result = this.getExpressionWrapper().evaluate(event, (Object)this.expectedException).getValue();
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new MunitError("Please make sure your expression matching for expectedException returns a boolean value");
        }
        catch (ExpressionRuntimeException e) {
            throw new MunitError("Expect exception expression error. " + e.getMessage());
        }
    }

    protected Boolean exceptionMatches(Error error) throws MunitError {
        Class<?> expectExceptionClass;
        ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            expectExceptionClass = Class.forName(this.expectedException, true, appClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new MunitError("The class " + error.getCause() + " could not be found", (Throwable)e);
        }
        return expectExceptionClass.isAssignableFrom(error.getCause().getClass());
    }

    protected void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    protected void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    protected void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void addProcessingStrategy(String childName, ProcessingStrategy processingStrategy) {
        this.childProcessingStrategies.put(childName, processingStrategy);
    }

    public void initialise() throws InitialisationException {
        this.scheduler = this.schedulerService.cpuLightScheduler(SchedulerConfig.config().withName("MUnit-Runner"));
        super.initialise();
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.childProcessingStrategies.values());
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
        LifecycleUtils.stopIfNeeded(this.childProcessingStrategies.values());
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        if (this.childProcessingStrategies != null) {
            LifecycleUtils.disposeIfNeeded(this.childProcessingStrategies.values(), (Logger)logger);
        }
        super.dispose();
    }

    protected List<ReactiveProcessor> processorChainsToExecute(List<MessageProcessorChain> chains) {
        return chains.stream().map(chain -> this.lookupProcessingStrategy((MessageProcessorChain)chain).map(strategy -> strategy.onPipeline((ReactiveProcessor)chain)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Optional<ProcessingStrategy> lookupProcessingStrategy(MessageProcessorChain chain) {
        return Optional.ofNullable(this.childProcessingStrategies.get(chain.getLocation().getComponentIdentifier().getIdentifier().getName()));
    }

    private MunitExpressionWrapper getExpressionWrapper() {
        return new MunitExpressionWrapper((ExpressionManager)this.extendedExpressionManager);
    }

    private List<MessageSource> getFlowSources(List<EnableFlowSources.FlowRef> enabledFlowSources) {
        return Optional.ofNullable(enabledFlowSources).map(flowSources -> flowSources.stream().map(EnableFlowSources.FlowRef::getFlow).filter(this::isFlow).map(component -> (Flow)component).map(Pipeline::getSource).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private boolean isFlow(Component component) {
        if (component instanceof Flow) {
            return true;
        }
        logger.warn("Component {} listed in enable-flow-sources section is not a flow", (Object)component);
        return false;
    }

    private Integer getTimeout() {
        String property = System.getProperty(MUNIT_TEST_TIMEOUT_PROPERTY);
        if (this.timeOut != null) {
            return this.timeOut;
        }
        if (property != null) {
            return Integer.valueOf(property);
        }
        return 120000;
    }

    private void validateIgnore(String ignore) {
        if (ignore == null) {
            throw new MunitError("Ignore expression error. The expression cannot be null");
        }
        if (ignore.isEmpty()) {
            throw new MunitError("Ignore expression error. The expression cannot be empty");
        }
        if (this.booleanPattern.matcher(ignore).matches()) {
            return;
        }
        MunitExpressionWrapper expressionWrapper = this.getExpressionWrapper();
        if (!expressionWrapper.isExpressionValid((Object)ignore)) {
            throw new MunitError(String.format("Ignore expression error. The expression \"%s\" is not valid", ignore));
        }
        if (!(expressionWrapper.evaluate((Object)ignore).getValue() instanceof Boolean)) {
            throw new MunitError(String.format("Ignore expression error. The expression \"%s\" should return a valid boolean", ignore));
        }
    }

    private boolean isMatch(SingleErrorTypeMatcher errorTypeMatcher, Error eventError) {
        return errorTypeMatcher.match(eventError.getErrorType()) || this.isSuppressedMatch(errorTypeMatcher, eventError);
    }

    private boolean isSuppressedMatch(SingleErrorTypeMatcher errorTypeMatcher, Error eventError) {
        if (getSuppressedErrorsMethod != null) {
            try {
                for (Error suppressedError : (List)getSuppressedErrorsMethod.invoke((Object)eventError, new Object[0])) {
                    ErrorType suppressedErrorType = suppressedError.getErrorType();
                    if (!errorTypeMatcher.match(suppressedErrorType)) continue;
                    this.warnAboutSuppressedErrorTypeMatch(eventError, suppressedErrorType);
                    return true;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
        }
        return false;
    }

    private void warnAboutSuppressedErrorTypeMatch(Error eventError, ErrorType suppressedErrorType) {
        if (this.logSuppressedMatch.compareAndSet(true, false)) {
            logger.warn("Expected error type from flow '{}' has matched the following underlying error: {}. Consider changing it to match the reported error: {}.", new Object[]{this.getLocation().getLocation(), suppressedErrorType, eventError.getErrorType()});
        }
    }

    @Deprecated
    protected static void setGetSuppressedErrorsMethod(Method suppressedErrorsMethod) {
        getSuppressedErrorsMethod = suppressedErrorsMethod;
    }

    static {
        try {
            getSuppressedErrorsMethod = Class.forName("org.mule.runtime.core.privileged.message.PrivilegedError", false, Error.class.getClassLoader()).getDeclaredMethod("getSuppressedErrors", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected class ExceptionAwareCallable
    implements Callable<Either<Event, Throwable>> {
        private final Event event;

        ExceptionAwareCallable(Event event) {
            this.event = event;
        }

        @Override
        public Either<Event, Throwable> call() {
            try {
                return Either.left(TestFlow.this.execute(this.event).get());
            }
            catch (Throwable t) {
                return Either.right((Object)t);
            }
        }
    }
}

