/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.simple;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.simple.MunitSimpleRunnerAction;
import org.mule.munit.runner.spring.config.model.MockingConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitSimpleRunner {
    private transient Log log = LogFactory.getLog(this.getClass());
    private String resources;
    private List<MunitSimpleRunnerAction> actions;
    private String projectName;

    public MunitSimpleRunner(String resources, List<MunitSimpleRunnerAction> actions, String projectName) {
        this.resources = resources;
        this.actions = actions;
        this.projectName = projectName;
    }

    public void run() {
        this.log.debug((Object)("Counting application flow paths: " + new Date().toString()));
        MuleContext muleContext = null;
        MuleContextManager muleContextManager = new MuleContextManager(this.createConfiguration());
        try {
            muleContext = muleContextManager.createMule(this.resources, this.projectName);
            for (MunitSimpleRunnerAction action : this.actions) {
                action.execute(muleContext);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != muleContext) {
                muleContextManager.killMule(muleContext);
            }
            this.log.debug((Object)("Application flow paths count done: " + new Date().toString()));
        }
    }

    public String getResources() {
        return this.resources;
    }

    private MockingConfiguration createConfiguration() {
        return new MockingConfiguration(false, new ArrayList<String>(), false, null);
    }
}

