/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.munit.assertion.processors.MunitTestFlow;
import org.mule.munit.common.MunitCore;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.runner.MuleEventBuilderWrapper;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.output.TestOutputHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitTest {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private List<MunitFlow> before;
    private List<MunitFlow> after;
    private MunitTestFlow test;
    private TestOutputHandler outputHandler;
    private MuleContext muleContext;

    public static String stack2string(Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception e2) {
            return "";
        }
    }

    public MunitTest(List<MunitFlow> before, MunitTestFlow test, List<MunitFlow> after, TestOutputHandler outputHandler, MuleContext muleContext) {
        this.before = before;
        this.after = after;
        this.test = test;
        this.outputHandler = outputHandler;
        this.muleContext = muleContext;
    }

    public String getName() {
        return this.test.getName();
    }

    public boolean isIgnore() {
        return this.test.isIgnore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult run() {
        long start;
        TestResult result;
        block13: {
            result = new TestResult(this.getName());
            this.logger.debug((Object)("About to run MUnit test: " + this.getName()));
            if (this.test.isIgnore()) {
                this.logger.debug((Object)("MUnit test: " + this.getName() + " is ignored it won't run."));
                result.setSkipped(true);
                return result;
            }
            start = System.currentTimeMillis();
            MuleEvent event = this.muleEvent((FlowConstruct)this.test);
            try {
                this.runBefore(event);
                this.showDescription();
                this.test.process(event);
                if (StringUtils.isNotBlank((String)this.test.getExpectException())) {
                    Assert.fail((String)("Exception matching '" + this.test.getExpectException() + "', but wasn't thrown"));
                }
            }
            catch (AssertionError t) {
                result.setFailure(this.buildNotifcationFrom((Throwable)((Object)t)));
            }
            catch (MuleException e) {
                try {
                    if (this.test.expectException((Throwable)e, event)) break block13;
                    Throwable cause = e.getCause();
                    if (cause != null && AssertionError.class.isAssignableFrom(cause.getClass())) {
                        cause.setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)event.getMuleContext()).toArray(new StackTraceElement[0]));
                        Notification notification = this.buildNotifcationFrom(cause);
                        result.setFailure(notification);
                        break block13;
                    }
                    e.setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)event.getMuleContext()).toArray(new StackTraceElement[0]));
                    Notification notification = this.buildNotifcationFrom(e);
                    result.setError(notification);
                }
                catch (AssertionError t) {
                    ((Throwable)((Object)t)).setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)event.getMuleContext()).toArray(new StackTraceElement[0]));
                    result.setFailure(this.buildNotifcationFrom((Throwable)((Object)t)));
                }
                catch (MunitError t) {
                    t.setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)event.getMuleContext()).toArray(new StackTraceElement[0]));
                    Notification notification = this.buildNotifcationFrom(t);
                    result.setError(notification);
                }
            }
            finally {
                MunitCore.reset((MuleContext)event.getMuleContext());
                this.runAfter(result, event);
            }
        }
        long end = System.currentTimeMillis();
        result.setTime(new Float(end - start).floatValue() / 1000.0f);
        return result;
    }

    private Notification buildNotifcationFrom(Throwable t) {
        return new Notification(t.getMessage(), MunitTest.stack2string(t));
    }

    private void runBefore(MuleEvent event) throws MuleException {
        this.logger.debug((Object)"Running before test scopes...");
        this.run(event, this.before);
    }

    private void runAfter(TestResult result, MuleEvent event) {
        this.logger.debug((Object)"Running after test scopes...");
        try {
            this.run(event, this.after);
        }
        catch (MuleException e) {
            result.setError(this.buildNotifcationFrom(e));
        }
        catch (AssertionError e) {
            result.setFailure(this.buildNotifcationFrom((Throwable)((Object)e)));
        }
    }

    private void run(MuleEvent event, List<MunitFlow> flows) throws MuleException {
        if (flows != null) {
            for (MunitFlow flow : flows) {
                this.outputHandler.printDescription(flow.getName(), flow.getDescription());
                flow.process(event);
            }
        }
    }

    private void showDescription() {
        this.outputHandler.printDescription(this.test.getName(), this.test.getDescription());
    }

    protected MuleEvent muleEvent(FlowConstruct flowConstruct) {
        return MuleEventBuilderWrapper.muleEvent(this.muleContext, flowConstruct);
    }
}

