/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.munit.common.extensions.MunitPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitPluginFactory {
    private transient Log logger = LogFactory.getLog(this.getClass());

    public Collection<MunitPlugin> loadPlugins(MuleContext context) {
        this.logger.debug((Object)"Loading MUnitPlugins...");
        ArrayList<MunitPlugin> munitPlugins = new ArrayList<MunitPlugin>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = contextClassLoader.getResources("META-INF/munit-plugin.properties");
            while (resources.hasMoreElements()) {
                Properties properties = new Properties();
                Object content = resources.nextElement().getContent();
                properties.load((InputStream)content);
                MunitPlugin plugin = this.createMunitPlugin(contextClassLoader, properties);
                if (plugin == null) continue;
                if (plugin instanceof MuleContextAware) {
                    ((MuleContextAware)plugin).setMuleContext(context);
                }
                munitPlugins.add(plugin);
                this.logger.debug((Object)("MUnit plugin: " + plugin.getClass().getCanonicalName() + " loaded"));
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not read the Classpath in order to get the plugin configurations");
        }
        return munitPlugins;
    }

    private MunitPlugin createMunitPlugin(ClassLoader contextClassLoader, Properties properties) {
        String property = properties.getProperty("plugin.className");
        try {
            if (property != null && !property.isEmpty()) {
                this.logger.debug((Object)("Attempting to load MUnit plugin: " + property));
                return (MunitPlugin)contextClassLoader.loadClass(property).newInstance();
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)("The class " + property + " could not be load"));
        }
        return null;
    }
}

