/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.java;

import java.util.List;
import junit.framework.TestCase;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.munit.assertion.processors.MunitTestFlow;
import org.mule.munit.common.MunitCore;
import org.mule.munit.runner.MunitMuleEventBuilder;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.output.TestOutputHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitTest
extends TestCase {
    private List<MunitFlow> before;
    private MunitTestFlow flow;
    private List<MunitFlow> after;
    private MuleContext muleContext;
    private TestOutputHandler outputHandler = new DefaultOutputHandler();

    public MunitTest(List<MunitFlow> before, MunitTestFlow flow, List<MunitFlow> after) {
        this.before = before;
        this.flow = flow;
        this.after = after;
        this.muleContext = flow.getMuleContext();
    }

    public String getName() {
        return this.flow.getName();
    }

    public int countTestCases() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        if (this.flow.isIgnore()) {
            return;
        }
        MuleEvent event = this.muleEvent();
        this.run(event, this.before);
        this.showDescription();
        try {
            this.flow.process(event);
        }
        catch (Throwable t) {
            if (!this.flow.expectException(t, event)) {
                t.setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)event.getMuleContext()).toArray(new StackTraceElement[0]));
                throw t;
            }
        }
        finally {
            MunitCore.reset((MuleContext)this.muleContext);
            this.run(event, this.after);
        }
    }

    private void run(MuleEvent event, List<MunitFlow> flows) throws MuleException {
        if (flows != null) {
            for (MunitFlow flow : flows) {
                this.outputHandler.printDescription(flow.getName(), flow.getDescription());
                flow.process(event);
            }
        }
    }

    private void showDescription() {
        this.outputHandler.printDescription(this.flow.getName(), this.flow.getDescription().replaceAll("\\.", "\\.%n"));
    }

    protected MuleEvent muleEvent() {
        return MunitMuleEventBuilder.buildGenericMuleEvent((MuleContext)this.muleContext);
    }
}

