/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.munit.remote.runtime.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * The set of products available
 *
 * @since 1.0
 * @author Mulesoft Inc.
 */
public enum Product {
  MULE(Collections.emptyList()), MULE_EE(Arrays.asList(MULE));

  private List<Product> supportedProducts;

  private Product(List supportedProducts) {
    this.supportedProducts = supportedProducts;
  }

  public boolean supports(Product product) {
    boolean var2;
    if (!product.equals(this)) {
      Stream var10000 = this.supportedProducts.stream();
      Objects.requireNonNull(product);
      if (!var10000.filter(product::equals).findAny().isPresent()) {
        var2 = false;
        return var2;
      }
    }

    var2 = true;
    return var2;
  }

  public static Product getProductByName(String coreLibraryName) {
    if (coreLibraryName == null) {
      return MULE_EE;
    } else if (!coreLibraryName.equals("Mule Core") && !coreLibraryName.equals("Mule 4 Runtime Extension model")) {
      if (!coreLibraryName.equals("Mule EE Core") && !coreLibraryName.equals("Mule 4 EE Runtime Extension model")) {
        throw new IllegalArgumentException(String.format("Core library name %s could not be recognized", coreLibraryName));
      } else {
        return MULE_EE;
      }
    } else {
      return MULE;
    }
  }
}
