/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.munit.remote.runtime.utils;

import org.mule.munit.common.util.Preconditions;

/**
 * A builder to create instances of {@link AbstractMuleArtifactModel} implementations.
 *
 * @param <T> type of the builder, used to enable builder pattern on subclasses methods
 * @param <M> type of the model being built, used to have type safety
 *
 * @author Mulesoft Inc.
 * @since 1.0
 */
public abstract class AbstractMuleArtifactModelBuilder<T extends AbstractMuleArtifactModelBuilder, M extends AbstractMuleArtifactModel> {

  private String name;
  private String minMuleVersion;
  private Product product;
  private MuleArtifactLoaderDescriptor bundleDescriptorLoader;
  private MuleArtifactLoaderDescriptor classLoaderModelDescriptorLoader;

  public AbstractMuleArtifactModelBuilder() {}

  public T setName(String name) {
    this.name = name;
    return this.getThis();
  }

  public T setRequiredProduct(Product product) {
    this.product = product;
    return this.getThis();
  }

  public String getName() {
    return this.name;
  }

  public Product getRequiredProduct() {
    return this.product;
  }

  protected abstract T getThis();

  public T setMinMuleVersion(String muleVersion) {
    this.minMuleVersion = muleVersion;
    return this.getThis();
  }

  public String getMinMuleVersion() {
    return this.minMuleVersion;
  }

  public T withBundleDescriptorLoader(MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
    Preconditions.checkArgument(bundleDescriptorLoader != null, "bundleDescriptorLoader cannot be null");
    this.bundleDescriptorLoader = bundleDescriptorLoader;
    return this.getThis();
  }

  public T withClassLoaderModelDescriptorLoader(MuleArtifactLoaderDescriptor classLoaderModelDescriptorLoader) {
    Preconditions.checkArgument(classLoaderModelDescriptorLoader != null, "classLoaderModelDescriptorLoader cannot be null");
    this.classLoaderModelDescriptorLoader = classLoaderModelDescriptorLoader;
    return this.getThis();
  }

  public MuleArtifactLoaderDescriptor getBundleDescriptorLoader() {
    return this.bundleDescriptorLoader;
  }

  public MuleArtifactLoaderDescriptor getClassLoaderModelDescriptorLoader() {
    return this.classLoaderModelDescriptorLoader;
  }

  public abstract M build();
}
