/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.coverage;

import static org.mule.munit.common.util.Preconditions.checkNotNull;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.mule.munit.remote.coverage.model.CoverageComponentLocationReport;
import org.mule.munit.remote.coverage.server.LocationPart;


/**
 * It sorts the location by different criteria
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class LocationGrouper {

  private Set<CoverageComponentLocationReport> locations;

  public LocationGrouper(Set<CoverageComponentLocationReport> locations) {
    checkNotNull(locations, "The covered location must not be null");
    this.locations = locations;
  }

  /**
   * It sort the {@link ComponentLocation} by containing flow
   * 
   * @return
   */
  public Map<LocationPart, Set<CoverageComponentLocationReport>> groupByFlow() {
    Map<LocationPart, Set<CoverageComponentLocationReport>> locationsPerFlow = new HashMap<>();

    for (CoverageComponentLocationReport location : locations) {
      LocationPart partIdentifier = location.getParts().get(0);

      if (!locationsPerFlow.containsKey(partIdentifier)) {
        locationsPerFlow.put(partIdentifier, new HashSet<>());
      }
      locationsPerFlow.get(partIdentifier).add(location);

    }
    return locationsPerFlow;
  }

  /**
   * It sorts the ComponentLocation by containing file
   * 
   * @return
   */
  public Map<String, Set<CoverageComponentLocationReport>> groupByFile() {

    Map<String, Set<CoverageComponentLocationReport>> locationsPerFile = new HashMap<>();

    for (CoverageComponentLocationReport location : locations) {
      String fileName = location.getFileName().get();

      if (!locationsPerFile.containsKey(fileName)) {
        locationsPerFile.put(fileName, new HashSet<>());
      }
      locationsPerFile.get(fileName).add(location);

    }
    return locationsPerFile;
  }

}
