/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.runtime.module.embedded.api.dependencies.MuleDependenciesResolver;
import org.mule.runtime.module.embedded.internal.classloading.JdkOnlyClassLoaderFactory;

public class MavenContainerClassLoaderFactory {
    private final MuleDependenciesResolver muleDependenciesResolver;

    public MavenContainerClassLoaderFactory(MuleDependenciesResolver muleDependenciesResolver) {
        this.muleDependenciesResolver = muleDependenciesResolver;
    }

    public ClassLoader create(URL containerBaseFolder) {
        try {
            List<URL> urls = this.resolveDependencies(this.muleDependenciesResolver);
            File containerFolderFile = FileUtils.toFile(containerBaseFolder);
            urls.add(new URL(new File(containerFolderFile, "conf").toURI() + "/"));
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.buildParentClassLoader(this.getClass().getClassLoader()));
        }
        catch (BundleDependenciesResolutionException e) {
            throw new IllegalArgumentException("Could not find embedded container bom artifact", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private List<URL> resolveDependencies(MuleDependenciesResolver muleDependenciesResolver) {
        ArrayList<URL> urls = new ArrayList<URL>(muleDependenciesResolver.resolveOptLibs());
        urls.addAll(muleDependenciesResolver.resolveMuleLibs());
        return urls;
    }

    protected final ClassLoader buildParentClassLoader(ClassLoader classLoader) {
        Set<String> additionalExportedBootPackages = Collections.emptySet();
        if (SystemUtils.isJavaVersionAtMost(JavaVersion.JAVA_11)) {
            additionalExportedBootPackages = new HashSet<String>(Arrays.asList("org.mule.runtime.module.embedded.internal.controller", "org.mule.runtime.module.embedded.api"));
        }
        return JdkOnlyClassLoaderFactory.create(classLoader, additionalExportedBootPackages);
    }

    protected final MuleDependenciesResolver getMuleDependenciesResolver() {
        return this.muleDependenciesResolver;
    }
}

