/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.coverage.model.CoverageComponentLocationReport;
import org.mule.munit.remote.coverage.server.LocationPart;

public class LocationGrouper {
    private Set<CoverageComponentLocationReport> locations;

    public LocationGrouper(Set<CoverageComponentLocationReport> locations) {
        Preconditions.checkNotNull(locations, "The covered location must not be null");
        this.locations = locations;
    }

    public Map<LocationPart, Set<CoverageComponentLocationReport>> groupByFlow() {
        HashMap<LocationPart, Set<CoverageComponentLocationReport>> locationsPerFlow = new HashMap<LocationPart, Set<CoverageComponentLocationReport>>();
        for (CoverageComponentLocationReport location : this.locations) {
            LocationPart partIdentifier = location.getParts().get(0);
            if (!locationsPerFlow.containsKey(partIdentifier)) {
                locationsPerFlow.put(partIdentifier, new HashSet());
            }
            ((Set)locationsPerFlow.get(partIdentifier)).add(location);
        }
        return locationsPerFlow;
    }

    public Map<String, Set<CoverageComponentLocationReport>> groupByFile() {
        HashMap<String, Set<CoverageComponentLocationReport>> locationsPerFile = new HashMap<String, Set<CoverageComponentLocationReport>>();
        for (CoverageComponentLocationReport location : this.locations) {
            String fileName = location.getFileName().get();
            if (!locationsPerFile.containsKey(fileName)) {
                locationsPerFile.put(fileName, new HashSet());
            }
            ((Set)locationsPerFile.get(fileName)).add(location);
        }
        return locationsPerFile;
    }
}

