/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.protocol.message;

import com.google.gson.Gson;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.RunMessage;

public class RunMessageParser {
    private RunEventListener listener;

    public RunMessageParser(RunEventListener listener) {
        this.listener = listener;
    }

    public void parseAndNotify(String message) {
        RunMessage cmd = new Gson().fromJson(message, RunMessage.class);
        switch (cmd.getId()) {
            case 12: {
                this.listener.notifyRunStart();
                break;
            }
            case 1: {
                this.listener.notifySuiteStart(cmd.get("munitSuite"), cmd.get("parameterizationKey"), Integer.parseInt(cmd.get("numberOfTests")));
                break;
            }
            case 2: {
                this.listener.notifyContainerFailure(cmd.get("stackTrace"));
                break;
            }
            case 13: {
                this.listener.notifyContainerFailure(cmd.get("munitSuite"), cmd.get("parameterizationKey"), cmd.get("stackTrace"));
                break;
            }
            case 3: {
                this.listener.notifyBeforeSuiteStart(cmd.get("name"));
                break;
            }
            case 4: {
                this.listener.notifyBeforeSuiteEnd(cmd.get("name"), cmd.get("stackTrace"), cmd.getStatus("status"));
                break;
            }
            case 5: {
                this.listener.notifyTestStart(cmd.get("name"), cmd.get("description"), cmd.getBoolean("ignored"), cmd.get("fileName"));
                break;
            }
            case 6: {
                this.listener.notifyTestEnd(cmd.get("name"), cmd.get("stackTrace"), cmd.getStatus("status"), cmd.getLong("elapsedTime"), cmd.get("fileName"));
                break;
            }
            case 7: {
                this.listener.notifyAfterSuiteStart(cmd.get("name"));
                break;
            }
            case 8: {
                this.listener.notifyAfterSuiteEnd(cmd.get("name"), cmd.get("stackTrace"), cmd.getStatus("status"));
                break;
            }
            case 9: {
                this.listener.notifySuiteEnd(cmd.get("munitSuite"), cmd.get("parameterizationKey"), cmd.getLong("elapsedTime"));
                break;
            }
            case 11: {
                this.listener.notifyRunFinish();
                break;
            }
            case 10: {
                this.listener.notifyCoverageReport(cmd.get("coverageReport"));
                break;
            }
            case 98: {
                this.listener.notifySuiteUnexpectedError(cmd.get("name"), cmd.get("stackTrace"));
                break;
            }
            case 99: {
                this.listener.notifyUnexpectedError(cmd.get("stackTrace"));
                break;
            }
            default: {
                this.listener.notifyUnknown(message);
            }
        }
    }
}

