/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AbstractAsciiList;
import de.vandermeer.asciilist.AbstractAsciiListItem;
import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.AsciiList_Itemize;
import de.vandermeer.asciilist.styles.ListStyle;
import de.vandermeer.asciilist.styles.ListStyle_ItemizeNested;
import de.vandermeer.asciilist.styles.NestedItemizeStyles;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ItemizeList
extends AbstractAsciiList
implements AsciiList_Itemize {
    protected ListStyle_ItemizeNested style;

    public ItemizeList() {
        this(true);
    }

    public ItemizeList(boolean isContinued) {
        super(isContinued);
        this.style = NestedItemizeStyles.ALL_STAR;
    }

    public ItemizeList(ItemizeList list) {
        super(list);
        this.style = list.style;
    }

    @Override
    public AsciiList_Itemize addItem(AsciiList list) {
        Validate.notEmpty(list.getItems());
        AsciiList add = list.copy();
        this.items.add(add);
        return this;
    }

    @Override
    public void prepareRender() {
        super.prepareRender();
        for (Object obj : this.items) {
            if (!(obj instanceof AsciiList_Itemize) || !((AsciiList_Itemize)obj).isContinuedList()) continue;
            ((AsciiList_Itemize)obj).setListStyle(this.style);
        }
    }

    @Override
    public String renderItem(AsciiListItem item, int position) {
        return item.render(this.preLabelIndent, this.preLabelStr, this.style.getLabel(this.level), this.postLabelStr, this.postLabelIndent);
    }

    @Override
    public AsciiList_Itemize setListStyle(ListStyle style) {
        if (style instanceof ListStyle_ItemizeNested) {
            this.style = (ListStyle_ItemizeNested)style;
        }
        return this;
    }

    @Override
    public AsciiList copy() {
        return new ItemizeList(this);
    }

    @Override
    public int calculateMaxIndentation(AsciiListItem item, int position) {
        return this.preLabelIndent + this.preLabelStr.length() + this.style.getLabel(this.level).length() + this.postLabelStr.length() + this.postLabelIndent;
    }

    @Override
    public AsciiList_Itemize addItem(String item) {
        if (!StringUtils.isBlank(item)) {
            this.items.add(new AbstractAsciiListItem(item));
        }
        return this;
    }

    @Override
    public AsciiList_Itemize addAllItems(Collection<String> items) {
        if (items != null) {
            for (String s : items) {
                this.addItem(s);
            }
        }
        return this;
    }
}

