/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.api.dependencies.MuleDependenciesResolver;
import org.mule.runtime.module.embedded.internal.MavenContainerClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.RuntimeProduct;
import org.mule.runtime.module.embedded.internal.utils.DependenciesUtils;
import org.mule.runtime.module.embedded.internal.utils.JpmsUtils;

public class MavenContainerOptSeparateClassLoaderFactory
extends MavenContainerClassLoaderFactory {
    private static final String ARTIFACT_INFO_PROPERTIES = "artifact-info.properties";
    private final MavenClient mavenClient;
    private final RuntimeProduct runtimeProduct;
    private final boolean isolate;

    public MavenContainerOptSeparateClassLoaderFactory(MuleDependenciesResolver muleDependenciesResolver, MavenClient mavenClient, RuntimeProduct runtimeProduct, boolean isolate) {
        super(muleDependenciesResolver);
        this.mavenClient = mavenClient;
        this.runtimeProduct = runtimeProduct;
        this.isolate = isolate;
    }

    @Override
    public ClassLoader create(URL containerBaseFolder) {
        try {
            File containerFolderFile = FileUtils.toFile(containerBaseFolder);
            URL configurationFolderUrl = new URL(new File(containerFolderFile, "conf").toURI() + "/");
            ClassLoader jpmsUtilsClassLoader = this.getJpmsUtilsClassLoader(this.getMuleDependenciesResolver().resolveMuleLibs());
            ClassLoader referenceClassLoader = this.getReferenceClassLoader(this.runtimeProduct, jpmsUtilsClassLoader);
            URLClassLoader parentClassLoader = new URLClassLoader(Collections.singletonList(configurationFolderUrl).toArray(new URL[1]), this.buildParentClassLoader(referenceClassLoader));
            return this.createModuleLayerClassLoader(this.getMuleDependenciesResolver().resolveOptLibs().toArray(new URL[0]), this.getMuleDependenciesResolver().resolveMuleLibs().toArray(new URL[0]), parentClassLoader, Optional.of(this.getReferenceClass(this.runtimeProduct, referenceClassLoader)), jpmsUtilsClassLoader);
        }
        catch (BundleDependenciesResolutionException e) {
            throw new IllegalArgumentException("Could not find embedded container bom artifact", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader createModuleLayerClassLoader(URL[] optUrls, URL[] muleUrls, ClassLoader parentClassLoader, Optional<Class> clazz, ClassLoader jpmsUtilsClassLoader) {
        if (SystemUtils.isJavaVersionAtMost(JavaVersion.JAVA_11)) {
            return new URLClassLoader(muleUrls, (ClassLoader)new URLClassLoader(optUrls, parentClassLoader));
        }
        try {
            Class<?> multiLevelClassLoaderFactoryClass = jpmsUtilsClassLoader.loadClass("org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory");
            Object multiLevelClassLoaderFactoryImpl = multiLevelClassLoaderFactoryClass.getField("MULTI_LEVEL_URL_CLASSLOADER_FACTORY").get(null);
            return this.createModuleLayerClassLoader(jpmsUtilsClassLoader, Arrays.asList(URL[].class, URL[].class, multiLevelClassLoaderFactoryClass, ClassLoader.class, Optional.class), Arrays.asList(optUrls, muleUrls, multiLevelClassLoaderFactoryImpl, parentClassLoader, clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader createModuleLayerClassLoader(ClassLoader jpmsUtilsClassLoader, List<Class<?>> parameterTypes, List<Object> parameters) {
        try {
            Method createModuleLayerClassLoaderMethod = jpmsUtilsClassLoader.loadClass("org.mule.runtime.jpms.api.JpmsUtils").getMethod("createModuleLayerClassLoader", parameterTypes.toArray(new Class[parameterTypes.size()]));
            return (ClassLoader)createModuleLayerClassLoaderMethod.invoke(null, parameters.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getJpmsUtilsClassLoader(List<URL> muleLibs) {
        String jpmsUtilsLibName = "mule-module-jpms-utils";
        URL jpmsUtilsLib = muleLibs.stream().filter(url -> url.toExternalForm().contains(jpmsUtilsLibName)).findFirst().orElse(null);
        if (jpmsUtilsLib == null) {
            throw new RuntimeException("Could not find '" + jpmsUtilsLibName + "' among mule libs");
        }
        ClassLoader jpmsUtilsClassLoader = JpmsUtils.createJpmsUtilsClassLoader(jpmsUtilsLib);
        return jpmsUtilsClassLoader;
    }

    private ClassLoader getReferenceClassLoader(RuntimeProduct runtimeProduct, ClassLoader jpmsUtilsClassLoader) {
        if (runtimeProduct.isSupportsIsolation() && this.isolate) {
            URL[] embeddedCommonsUrls = new URL[]{this.getEmbeddedCommons()};
            ClassLoader parent = ClassLoader.getSystemClassLoader().getParent();
            if (SystemUtils.isJavaVersionAtMost(JavaVersion.JAVA_11)) {
                return new URLClassLoader(embeddedCommonsUrls, parent);
            }
            return this.createModuleLayerClassLoader(jpmsUtilsClassLoader, Arrays.asList(URL[].class, ClassLoader.class), Arrays.asList(embeddedCommonsUrls, parent));
        }
        return this.getClass().getClassLoader();
    }

    private Class<?> getReferenceClass(RuntimeProduct runtimeProduct, ClassLoader referenceClassLoader) {
        if (runtimeProduct.isSupportsIsolation() && this.isolate) {
            return this.getEmbeddedCommonsClass(referenceClassLoader);
        }
        return this.getClass();
    }

    private Class<?> getEmbeddedCommonsClass(ClassLoader commonsClassLoader) {
        try {
            return commonsClassLoader.loadClass("org.mule.runtime.module.embedded.commons.api.ArtifactConfiguration");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private URL getEmbeddedCommons() {
        BundleDescriptor embeddedCommonsBundleDescriptor = new BundleDescriptor.Builder().setGroupId("org.mule.runtime").setArtifactId("mule-embedded-commons").setVersion(this.getImplementationVersion()).setType("jar").build();
        return DependenciesUtils.dependencyToUrl().apply(this.mavenClient.resolveBundleDescriptor(embeddedCommonsBundleDescriptor));
    }

    private String getImplementationVersion() {
        try {
            Properties artifactInfo = new Properties();
            artifactInfo.load(this.getClass().getClassLoader().getResourceAsStream(ARTIFACT_INFO_PROPERTIES));
            return artifactInfo.getProperty("artifact-version");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

