/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.printer;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.coverage.model.ApplicationCoverageReport;
import org.mule.munit.remote.coverage.model.CoverageLimits;
import org.mule.munit.remote.coverage.model.MuleFlow;
import org.mule.munit.remote.coverage.model.MuleResource;
import org.mule.munit.remote.coverage.printer.CoverageReportPrinter;
import org.mule.munit.remote.coverage.printer.model.CoverageReportModel;
import org.mule.munit.remote.coverage.printer.model.MuleFlowModel;
import org.mule.munit.remote.coverage.printer.model.MuleResourceModel;

public class JsonPrinter
implements CoverageReportPrinter {
    public static final String PRINTER_NAME = "Json";
    private final File reportFile;
    private CoverageLimits configuration;

    public JsonPrinter(CoverageLimits coverageLimits, File reportFile) {
        Preconditions.checkNotNull(reportFile, "The report path cannot be null");
        Preconditions.checkNotNull(coverageLimits, "The coverage limits cannot be null");
        this.configuration = coverageLimits;
        this.reportFile = reportFile;
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(ApplicationCoverageReport report) {
        try {
            CoverageReportModel coverageReportModel = this.generateReportModel(report);
            this.reportFile.createNewFile();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), StandardCharsets.UTF_8);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)coverageReportModel, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CoverageReportModel generateReportModel(ApplicationCoverageReport report) {
        CoverageReportModel coverageReportModel = new CoverageReportModel(report, this.configuration);
        ArrayList<MuleResourceModel> files = new ArrayList<MuleResourceModel>();
        for (MuleResource resource : report.getResources()) {
            MuleResourceModel resourceModel = new MuleResourceModel(resource);
            ArrayList<MuleFlowModel> flows = new ArrayList<MuleFlowModel>();
            for (MuleFlow flow : resource.getFlows()) {
                flows.add(new MuleFlowModel(flow));
            }
            resourceModel.setFlows(flows);
            files.add(resourceModel);
        }
        coverageReportModel.setFiles(files);
        return coverageReportModel;
    }
}

