/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.mule.munit.remote.api.configuration.EmbeddedContainerConfiguration;

@JsonAdapter(value=ContainerConfigurationAdapter.class)
public abstract class ContainerConfiguration {
    private String runtimeId;
    private String product;
    private String munitWorkingDirectoryPath;
    private String log4JConfigurationFilePath;
    protected String type;
    private Map<String, String> systemPropertyVariables;
    private Map<String, String> environmentVariables;
    private String runtimeLocalDistribution;

    public ContainerConfiguration(String runtimeId, String product, String munitWorkingDirectoryPath, String log4JConfigurationFilePath, Map<String, String> systemPropertyVariables, Map<String, String> environmentVariables, String runtimeLocalDistribution) {
        this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
        this.log4JConfigurationFilePath = log4JConfigurationFilePath;
        this.runtimeId = runtimeId;
        this.product = product;
        this.systemPropertyVariables = systemPropertyVariables;
        this.environmentVariables = environmentVariables;
        this.runtimeLocalDistribution = runtimeLocalDistribution;
    }

    public ContainerConfiguration() {
    }

    public String getMunitWorkingDirectoryPath() {
        return this.munitWorkingDirectoryPath;
    }

    public String getLog4JConfigurationFilePath() {
        return this.log4JConfigurationFilePath;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getRuntimeLocalDistribution() {
        return this.runtimeLocalDistribution;
    }

    public String getProduct() {
        return this.product;
    }

    public Map<String, String> getSystemPropertyVariables() {
        return this.systemPropertyVariables;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    static class ContainerConfigurationAdapter
    extends TypeAdapter<ContainerConfiguration> {
        private static final String TYPE = "type";
        private static final String VALUE = "value";
        private static final Gson gson = new Gson();

        ContainerConfigurationAdapter() {
        }

        @Override
        public void write(JsonWriter out, ContainerConfiguration containerConfiguration) throws IOException {
            out.beginObject();
            out.name(VALUE);
            gson.toJson((Object)containerConfiguration, (Type)((Object)EmbeddedContainerConfiguration.class), out);
            out.endObject();
        }

        @Override
        public ContainerConfiguration read(JsonReader in) throws IOException {
            in.beginObject();
            if (!VALUE.equals(in.nextName())) {
                throw new IOException("Container configuration serialized does not have the value field");
            }
            ContainerConfiguration containerConfiguration = (ContainerConfiguration)gson.fromJson(in, (Type)((Object)EmbeddedContainerConfiguration.class));
            in.endObject();
            return containerConfiguration;
        }
    }

    public static interface ContainerConfigurationBuilder {
        public ContainerConfiguration build();
    }
}

