/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    private static final String META_INF = "META-INF";
    private static final String MAVEN_PATH = "META-INF/maven";
    private static final String MULE_PLUGIN_POM = "pom.xml";

    public static URL getPomUrlFromJar(File artifactFile) {
        try {
            List<URL> jarMavenUrls = FileUtils.getUrlsWithinJar(artifactFile, MAVEN_PATH);
            if (jarMavenUrls.isEmpty()) {
                JarFile jarFile = new JarFile(artifactFile);
                try {
                    throw new RuntimeException(String.format("No entries found in %s for artifact %s.\nFound entries: %s", MAVEN_PATH, artifactFile.getName(), jarFile.stream().map(ZipEntry::getName).collect(Collectors.toList())));
                }
                catch (Throwable throwable) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Optional<URL> pomUrl = jarMavenUrls.stream().filter(url -> url.toString().endsWith(MULE_PLUGIN_POM)).findAny();
            if (!pomUrl.isPresent()) {
                String expectedPath = "META-INF/maven/${groupId}/${artifactId}/pom.xml";
                throw new RuntimeException(String.format("The file '%s' was missing while looking within the artifact %s (it should be placed under [%s]).\nFound URLs in Maven folder: %s", MULE_PLUGIN_POM, artifactFile.getName(), expectedPath, jarMavenUrls));
            }
            return pomUrl.get();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<byte[]> loadFileContentFrom(URL jarFile) throws IOException {
        Optional<byte[]> optional;
        block8: {
            JarURLConnection jarConnection = (JarURLConnection)jarFile.openConnection();
            jarConnection.setUseCaches(false);
            InputStream stream = jarConnection.getInputStream();
            try {
                optional = Optional.of(IOUtils.toByteArray(stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    private static URL getUrlWithinJar(File jarFile, String filePath) throws MalformedURLException {
        return new URL("jar:" + jarFile.toURI().toString() + "!/" + filePath);
    }

    private static List<URL> getUrlsWithinJar(File file, String directory) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().startsWith(directory + "/")) continue;
                urls.add(FileUtils.getUrlWithinJar(file, jarEntry.getName()));
            }
        }
        return urls;
    }

    public static File newFile(String pathName) {
        try {
            return new File(pathName).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create a canonical file for " + pathName, e);
        }
    }
}

