/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import java.util.List;
import org.eclipse.sisu.bean.BeanBinder;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.PropertyBinder;
import org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.PlexusBeanSource;
import org.eclipse.sisu.plexus.PlexusPropertyBinder;

final class PlexusBeanBinder
implements BeanBinder,
InjectionListener<Object> {
    private final BeanManager manager;
    private final PlexusBeanSource[] sources;

    PlexusBeanBinder(BeanManager manager, List<PlexusBeanSource> sources) {
        this.manager = manager;
        this.sources = sources.toArray(new PlexusBeanSource[sources.size()]);
    }

    @Override
    public <B> PropertyBinder bindBean(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        Class clazz = type.getRawType();
        if (null != this.manager && this.manager.manage(clazz)) {
            encounter.register((InjectionListener)this);
        }
        for (PlexusBeanSource source : this.sources) {
            PlexusBeanMetadata metadata = source.getBeanMetadata(clazz);
            if (metadata == null) continue;
            return new PlexusPropertyBinder(this.manager, encounter, metadata);
        }
        return null;
    }

    public void afterInjection(Object bean) {
        this.manager.manage(bean);
    }
}

