/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.Preconditions;

public class ClassUtils
extends org.apache.commons.lang3.ClassUtils {
    public static final Object[] NO_ARGS = new Object[0];
    private static final Map<Class<?>, Class<?>> wrapperToPrimitiveMap = new HashMap();
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);

    public static URL getResource(String resourceName, Class<?> callingClass) {
        URL url = AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl != null ? cl.getResource(resourceName) : null;
        });
        if (url == null) {
            url = AccessController.doPrivileged(() -> ClassUtils.class.getClassLoader().getResource(resourceName));
        }
        if (url == null) {
            url = AccessController.doPrivileged(() -> callingClass.getClassLoader().getResource(resourceName));
        }
        return url;
    }

    public static Enumeration<URL> getResources(String resourceName, ClassLoader fallbackClassLoader) {
        Preconditions.checkArgument(!StringUtils.isEmpty(resourceName), "ResourceName cannot be empty");
        Preconditions.checkArgument(fallbackClassLoader != null, "FallbackClassLoader cannot be null");
        Enumeration enumeration = AccessController.doPrivileged(() -> {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl.getResources(resourceName) : null;
            }
            catch (IOException e) {
                return null;
            }
        });
        if (enumeration == null) {
            enumeration = AccessController.doPrivileged(() -> {
                try {
                    return ClassUtils.class.getClassLoader().getResources(resourceName);
                }
                catch (IOException e) {
                    return null;
                }
            });
        }
        if (enumeration == null) {
            enumeration = AccessController.doPrivileged(() -> {
                try {
                    return fallbackClassLoader.getResources(resourceName);
                }
                catch (IOException e) {
                    return null;
                }
            });
        }
        return enumeration;
    }

    public static boolean isClassOnPath(String className, Class currentClass) {
        try {
            return ClassUtils.loadClass(className, currentClass) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        return ClassUtils.loadClass(className, callingClass, Object.class);
    }

    public static <T extends Class> T loadClass(String className, Class<?> callingClass, T type) throws ClassNotFoundException {
        if (className.length() <= 8 && primitiveTypeNameMap.containsKey(className)) {
            return (T)primitiveTypeNameMap.get(className);
        }
        Class clazz = AccessController.doPrivileged(() -> {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl.loadClass(className) : null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return ClassUtils.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return callingClass.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        if (type.isAssignableFrom(clazz)) {
            return (T)clazz;
        }
        throw new IllegalArgumentException(String.format("Loaded class '%s' is not assignable from type '%s'", clazz.getName(), type.getName()));
    }

    public static Object instantiateClass(String name, Object[] constructorArgs, Class<?> callingClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = ClassUtils.loadClass(name, callingClass);
        return ClassUtils.instantiateClass(clazz, constructorArgs);
    }

    private static <T> T instantiateClass(Class<? extends T> clazz, Object ... constructorArgs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor ctor;
        Class[] args;
        if (constructorArgs != null) {
            args = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                args[i] = constructorArgs[i] == null ? null : constructorArgs[i].getClass();
            }
        } else {
            args = new Class[]{};
        }
        if ((ctor = ClassUtils.getConstructor(clazz, args)) == null) {
            ctor = ClassUtils.getConstructor(clazz, ClassUtils.wrappersToPrimitives(args));
        }
        if (ctor == null) {
            StringBuilder argsString = new StringBuilder(100);
            for (Class arg : args) {
                argsString.append(arg.getName()).append(", ");
            }
            throw new NoSuchMethodException("could not find constructor on class: " + clazz + ", with matching arg params: " + argsString);
        }
        return ctor.newInstance(constructorArgs);
    }

    private static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        return ClassUtils.getConstructor(clazz, paramTypes, false);
    }

    private static Constructor getConstructor(Class clazz, Class[] paramTypes, boolean exactMatch) {
        for (Constructor<?> ctor : clazz.getConstructors()) {
            Class<?>[] types = ctor.getParameterTypes();
            if (types.length != paramTypes.length) continue;
            int matchCount = 0;
            for (int x = 0; x < types.length; ++x) {
                if (paramTypes[x] == null) {
                    ++matchCount;
                    continue;
                }
                if (exactMatch) {
                    if (!paramTypes[x].equals(types[x]) && !types[x].equals(paramTypes[x])) continue;
                    ++matchCount;
                    continue;
                }
                if (!paramTypes[x].isAssignableFrom(types[x]) && !types[x].isAssignableFrom(paramTypes[x])) continue;
                ++matchCount;
            }
            if (matchCount != types.length) continue;
            return ctor;
        }
        return null;
    }

    static {
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Void.TYPE, Void.TYPE);
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(wrapperToPrimitiveMap.values());
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
    }
}

