/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.EmbeddedContainerConfiguration;
import org.mule.munit.remote.api.configuration.Repository;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;
import org.mule.munit.remote.container.BundleDescriptorFactory;
import org.mule.munit.remote.container.Container;
import org.mule.munit.remote.container.ContainerFactoryException;
import org.mule.munit.remote.container.EmbeddedContainer;
import org.mule.munit.remote.logging.Log4jConfigurator;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.Product;

public class EmbeddedContainerFactory {
    private transient Logger log = LogManager.getLogger(this.getClass());
    protected static final String MAVEN_CENTRAL_ID = "maven-central";
    protected static final String MULESOFT_PUBLIC_ID = "mulesoft-public";
    protected static final String MAVEN_CENTRAL_URL = "https://repo.maven.apache.org/maven2/";
    protected static final String MULESOFT_PUBLIC_URL = "https://repository.mulesoft.org/nexus/content/repositories/public";

    public Container createContainer(RunConfiguration runConfiguration) throws ContainerFactoryException {
        EmbeddedContainerConfiguration configuration = (EmbeddedContainerConfiguration)runConfiguration.getContainerConfiguration();
        Path munitWorkingDirectoryPath = Paths.get(configuration.getMunitWorkingDirectoryPath(), new String[0]);
        File containerBaseFolder = munitWorkingDirectoryPath.resolve(FolderNames.CONTAINER.value()).toFile();
        Optional<File> runtimeLocalDistribution = Optional.ofNullable(configuration.getRuntimeLocalDistribution()).map(File::new);
        String runtimeVersion = configuration.getRuntimeId();
        String product = configuration.getProduct();
        URI log4JConfiguration = this.getLog4JConfiguration(configuration);
        BundleDescriptor[] serverPlugins = BundleDescriptorFactory.buildServerPluginDescriptors(configuration.getServerPluginConfigurations());
        this.loadServerPluginProperties(configuration.getServerPluginConfigurations());
        ContainerConfiguration containerConfiguration = ContainerConfiguration.builder().containerFolder(containerBaseFolder).serverPlugins(serverPlugins).build();
        return new EmbeddedContainer(org.mule.runtime.module.embedded.api.EmbeddedContainer.builder().muleVersion(runtimeVersion).product(Product.valueOf(product)).log4jConfigurationFile(log4JConfiguration).containerConfiguration(containerConfiguration).mavenConfiguration(this.getMavenConfiguration(configuration.getMavenConfiguration())).useIsolation(false).fromLocalDistribution(runtimeLocalDistribution.map(File::toPath).orElse(null)).build(), runConfiguration);
    }

    protected URI getLog4JConfiguration(EmbeddedContainerConfiguration runConfig) throws ContainerFactoryException {
        try {
            File log4JConfigurationFile;
            String log4JConfigurationFilePath = runConfig.getLog4JConfigurationFilePath();
            if (StringUtils.isNotBlank(log4JConfigurationFilePath) && (log4JConfigurationFile = Paths.get(log4JConfigurationFilePath, new String[0]).toFile()) != null && log4JConfigurationFile.exists()) {
                return log4JConfigurationFile.toURI();
            }
            return Log4jConfigurator.getDefaultLog4jConfiguration();
        }
        catch (IOException e) {
            throw new ContainerFactoryException("Unable to obtainer log4j configuration file to create container", e);
        }
    }

    protected void loadServerPluginProperties(List<ServerPluginConfiguration> pluginConfig) {
        if (pluginConfig != null) {
            pluginConfig.stream().filter(config -> config.getProperties() != null).forEach(config -> System.getProperties().putAll(config.getProperties()));
        }
    }

    protected MavenConfiguration getMavenConfiguration(org.mule.munit.remote.api.configuration.MavenConfiguration configuration) throws ContainerFactoryException {
        File securitySettingsFile;
        File globalSettingsXml;
        File settingsXml;
        File mavenRepository;
        MavenConfiguration.MavenConfigurationBuilder builder = MavenConfiguration.newMavenConfigurationBuilder();
        if (configuration.getMavenRepositoryDirectoryPath() != null && (mavenRepository = Paths.get(configuration.getMavenRepositoryDirectoryPath(), new String[0]).toFile()).exists()) {
            builder.localMavenRepositoryLocation(mavenRepository);
        }
        if (configuration.getSettingsXmlFilePath() != null && (settingsXml = Paths.get(configuration.getSettingsXmlFilePath(), new String[0]).toFile()).exists()) {
            builder.userSettingsLocation(settingsXml);
        }
        if (configuration.getGlobalSettingsXmlFilePath() != null && (globalSettingsXml = Paths.get(configuration.getGlobalSettingsXmlFilePath(), new String[0]).toFile()).exists()) {
            builder.globalSettingsLocation(globalSettingsXml);
        }
        if (configuration.getSecuritySettingsFilePath() != null && (securitySettingsFile = Paths.get(configuration.getSecuritySettingsFilePath(), new String[0]).toFile()).exists()) {
            builder.settingsSecurityLocation(securitySettingsFile);
        }
        builder.activeProfiles(configuration.getActiveProfiles());
        builder.offlineMode(configuration.getOfflineMode());
        builder.ignoreArtifactDescriptorRepositories(configuration.getIgnoreArtifactDescriptorRepositories());
        if (configuration.getForcePolicyUpdate().booleanValue()) {
            builder.forcePolicyUpdateNever(false);
        } else {
            builder.forcePolicyUpdateNever(true);
        }
        this.addDefaultRepositories(builder, configuration);
        return builder.build();
    }

    protected void addDefaultRepositories(MavenConfiguration.MavenConfigurationBuilder builder, org.mule.munit.remote.api.configuration.MavenConfiguration configuration) throws ContainerFactoryException {
        try {
            builder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id(MAVEN_CENTRAL_ID).url(new URL(MAVEN_CENTRAL_URL)).build());
            builder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id(MULESOFT_PUBLIC_ID).url(new URL(MULESOFT_PUBLIC_URL)).build());
        }
        catch (MalformedURLException e) {
            throw new ContainerFactoryException("Malformed URLs when adding default repositories", e);
        }
        for (Repository repository : configuration.getRemoteRepositories()) {
            if (repository.getId().equals(MAVEN_CENTRAL_ID) || repository.getId().equals(MULESOFT_PUBLIC_ID)) continue;
            try {
                builder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id(repository.getId()).url(new URL(repository.getUrl())).build());
            }
            catch (MalformedURLException e) {
                this.log.warn("Repository " + repository.getUrl() + " could not be added as a repository to download dependencies for the container.");
            }
        }
    }
}

