/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.net.URI;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WagonRedirectStrategy
extends DefaultRedirectStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(WagonRedirectStrategy.class);
    private static final int SC_PERMANENT_REDIRECT = 308;

    public WagonRedirectStrategy() {
        super(new String[]{"GET", "HEAD", "PUT", "MKCOL"});
    }

    @Override
    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        int statusCode = response.getStatusLine().getStatusCode();
        String method = request.getRequestLine().getMethod();
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return this.isRedirectable(method);
            }
        }
        return false;
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        HttpEntityEnclosingRequest encRequest;
        URI uri = this.getLocationURI(request, response, context);
        if (request instanceof HttpEntityEnclosingRequest && (encRequest = (HttpEntityEnclosingRequest)request).getEntity() instanceof AbstractHttpClientWagon.WagonHttpEntity) {
            AbstractHttpClientWagon.WagonHttpEntity whe = (AbstractHttpClientWagon.WagonHttpEntity)encRequest.getEntity();
            if (whe.getWagon() instanceof AbstractHttpClientWagon) {
                AbstractHttpClientWagon httpWagon = (AbstractHttpClientWagon)whe.getWagon();
                TransferEvent transferEvent = new TransferEvent((Wagon)httpWagon, whe.getResource(), 1, 6);
                transferEvent.setTimestamp(System.currentTimeMillis());
                transferEvent.setLocalFile(whe.getSource());
                httpWagon.getTransferEventSupport().fireDebug(String.format("Following redirect from '%s' to '%s'", request.getRequestLine().getUri(), uri.toASCIIString()));
                httpWagon.getTransferEventSupport().fireTransferStarted(transferEvent);
            } else {
                LOGGER.warn("Cannot properly handle redirect transfer event, wagon has unexpected class: {}", (Object)whe.getWagon().getClass());
            }
        }
        return RequestBuilder.copy(request).setUri(uri).build();
    }
}

