/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j;

import com.evanlennick.retry4j.CallExecutor;
import com.evanlennick.retry4j.RetryExecutor;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.listener.RetryListener;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class AsyncCallExecutor<T>
implements RetryExecutor<T, CompletableFuture<Status<T>>> {
    private RetryConfig config;
    private ExecutorService executorService;
    private RetryListener<T> afterFailedTryListener;
    private RetryListener<T> beforeNextTryListener;
    private RetryListener<T> onFailureListener;
    private RetryListener<T> onSuccessListener;
    private RetryListener<T> onCompletionListener;

    AsyncCallExecutor(RetryConfig config, ExecutorService executorService, RetryListener<T> afterFailedTryListener, RetryListener<T> beforeNextTryListener, RetryListener<T> onFailureListener, RetryListener<T> onSuccessListener, RetryListener<T> onCompletionListener) {
        this.config = config;
        this.executorService = executorService;
        this.afterFailedTryListener = afterFailedTryListener;
        this.beforeNextTryListener = beforeNextTryListener;
        this.onFailureListener = onFailureListener;
        this.onSuccessListener = onSuccessListener;
        this.onCompletionListener = onCompletionListener;
    }

    @Override
    public CompletableFuture<Status<T>> execute(Callable<T> callable) {
        return this.execute((Callable)callable, (String)null);
    }

    @Override
    public CompletableFuture<Status<T>> execute(Callable<T> callable, String callName) {
        CallExecutor<T> synchronousCallExecutor = new CallExecutor<T>(this.config, this.afterFailedTryListener, this.beforeNextTryListener, this.onFailureListener, this.onSuccessListener, this.onCompletionListener);
        CompletableFuture<Status<T>> completableFuture = new CompletableFuture<Status<T>>();
        if (this.executorService != null) {
            this.executorService.submit(() -> this.executeFuture(callable, callName, synchronousCallExecutor, completableFuture));
        } else {
            new Thread(() -> this.executeFuture(callable, callName, synchronousCallExecutor, completableFuture)).start();
        }
        return completableFuture;
    }

    private void executeFuture(Callable<T> callable, String callName, CallExecutor<T> synchronousCallExecutor, CompletableFuture<Status<T>> completableFuture) {
        try {
            Object status = synchronousCallExecutor.execute((Callable)callable, callName);
            completableFuture.complete((Status<Object>)status);
        }
        catch (Throwable t) {
            completableFuture.completeExceptionally(t);
        }
    }

    public RetryConfig getConfig() {
        return this.config;
    }

    public RetryListener<T> getAfterFailedTryListener() {
        return this.afterFailedTryListener;
    }

    public RetryListener<T> getBeforeNextTryListener() {
        return this.beforeNextTryListener;
    }

    public RetryListener<T> getOnFailureListener() {
        return this.onFailureListener;
    }

    public RetryListener<T> getOnSuccessListener() {
        return this.onSuccessListener;
    }

    public RetryListener<T> getOnCompletionListener() {
        return this.onCompletionListener;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Deprecated
    public ExecutorService getThreadExecutorService() {
        return this.executorService;
    }
}

