/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.properties.deploy;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.munit.remote.properties.deploy.DeploymentProperties;

public class TemporaryFolderProperties
implements DeploymentProperties {
    protected static final String MUNIT_TEMP_DIR_PROPERTY = "munit.temporary.directory";
    protected static final String MUNIT_TEMP_DIR_PREFIX = "munit-temp-dir";
    private transient Logger log = LogManager.getLogger(this.getClass());

    @Override
    public Map<String, String> get() {
        try {
            Path temporaryDirectory = Files.createTempDirectory(MUNIT_TEMP_DIR_PREFIX, new FileAttribute[0]);
            this.log.debug("Temporary directory created in {}", (Object)temporaryDirectory);
            return Collections.singletonMap(MUNIT_TEMP_DIR_PROPERTY, temporaryDirectory.toString());
        }
        catch (IOException e) {
            this.log.error("Unable to create temporary folder", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

